/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpx_with_container.cc"
 *									  created: 20/6/95 {6:05:52	pm}	
 *								  last update: 26/6/96 {3:15:23 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpx_with_container.icc"

#include "cpx_object.h"
#include <string.h>

cpx_with_container::~cpx_with_container(void) {
}

void cpx_with_container::destroy_so_remove_me(void) {
	if(container)
		container->contents.remove(this);
}
	
cpx_error cpx_with_container::move_to(cpx_object* new_container) {
    cpx_error e(new_container->add_some_object((cpx_base*)cast_to_base()));
    	if(e.error != cpx_error::OK) {
		// abort the operation if the new container won't take me
		return e;
    }

    // Now we're commited, so the old container cannot signal an error
    // It is allowed to warn, however.
    
    e = container->remove_some_object((cpx_base*)cast_to_base());
    this->container = new_container;
    archive() << cast_to_base()->get_tcl_command() << " moveTo " 
			  << new_container->get_tcl_command() << endl;
    return e;
}

int cpx_with_container::parse_tcl_command(bool& used, tcl_args& arg){	
    if (arg("object","move me to another object")=="moveTo") {
		const char * d;
		arg >> d >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		cpx_object* dest = 
		(cpx_object*) getCpxBaseByName(cast_to_base()->get_tcl_stream(),
												  d);
	    if (!dest){
			Tcl_AppendResult(cast_to_base()->get_interp(), 
							 cast_to_base()->get_tcl_command(), 
							 ": No such object.",NULL);
							 
			return TCL_ERROR;
	    }
	    move_to(dest);
	    used = true;
	    return TCL_OK;
    } else if (arg("","return the object which contains me")=="getContainer") {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		used = true;
		if(container) {
		    Tcl_SetResult(cast_to_base()->get_interp(), 
		    				container->get_tcl_command(), 
						  TCL_VOLATILE);
		    return TCL_OK;
		} else {
		    Tcl_SetResult(cast_to_base()->get_interp(), 
						  "Can't ask for container of the simulation.",
						  TCL_VOLATILE);
		    return TCL_ERROR;
		}	    
		
    } else  {
    	// just return
    	return TCL_OK;
    }
    
    
}

