/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_base.cc"
 *								   created:		1/24/95	{7:22:36 pm}
 *								   last	update:	26/6/96 {3:14:05 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "info_base.h"
#include "cpx_base.icc"
#include "cpx_with_info.h"
#include "object_control.h"
#include <strstream.h>
#include "util.h"
#include <string.h>

extern Tcl_HashTable info_table;

const char * info_base::_type = "Information";

ostream& info_base::write_to_stream(ostream& o) {
	return o;
}

istream& info_base::read_from_stream(istream& i) {
	return i;
}

info_base::info_base(info_base& i)
:cpx_base(i),cpx_with_container(i.container) { 
	// copy myself - perhaps not necessary
}

//static
const char* info_base::prepend_plus(cpx_with_info* cont, const char* name){
    ostrstream str;
    str << cont->get_tcl_command() << ':' << name << ends;
    return cpx_to_tcl((const char*) str.str());
}

info_base::info_base(const char* name, cpx_with_info* icontainer)
	:cpx_base(icontainer->get_tcl_stream(),prepend_plus(icontainer, name)),
	 cpx_with_container(icontainer)
{
	s_me = 0;
	// add me to my container
	container->add_info(this);
}

void info_base::find_static_part(const char* name) {
	ostrstream str;
	str << container->type() << ":" << name << ends;	
	int _new;
	Tcl_HashEntry *entry = Tcl_CreateHashEntry(&info_table,str.str(),&_new);
	if(!_new) {
		// we already have one - so use that
		s_me = (s_info_base*) Tcl_GetHashValue(entry);
	} else  {
		s_me = new_static(name);
		Tcl_SetHashValue(entry, (ClientData) s_me);
	}
}

info_base::~info_base(void) {
	destroy_so_remove_me();
}


const char* info_base::name(void) const {
	return s_me->_name;
}

int info_base::parse_tcl_command(tcl_args& arg){	
	bool used = false;
	if (cpx_with_container::parse_tcl_command(used,arg))
		return TCL_ERROR;
	else 
		if(used) return TCL_OK;
	
    if (arg("","return name of information")=="getName") {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		tcl_ << name() << result;
		return TCL_OK;
    } else if (arg("info","add info to me")=="connect") {
		const char* ev;
		arg >> ev >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		cpx_base* o = getCpxBaseByName(tcl_, ev);
		info_base* test;
		if (!o || !(test = ckcast(o,info_base))) {
			tcl_ <<  get_tcl_command() << ": No such object."<< tcl_error;
			return TCL_ERROR;
		}
		add_info(test);
		return TCL_OK;
	} else if (arg("info","remove info from me")=="disconnect") {
		const char* ev;
		arg >> ev >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		cpx_base* o = getCpxBaseByName(tcl_, ev);
		info_base* test;
		if (!o || !(test = ckcast(o,info_base))) {
			tcl_ <<  get_tcl_command() << ": No such object."<< tcl_error;
			return TCL_ERROR;
		}
		remove_info(test);
		return TCL_OK;
    } else if (arg("","returns nothing for this type")=="getContents") {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		    // information must return nothing
		return TCL_OK;
    } else if (arg("","ignore this, it probably shouldn't exist")=="getWindow") {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
    	// we never own windows, but want to recognise the command
    	// for completeness
		return TCL_OK;
    } else  // if we don't recognize the command, see if cpx_object does
		return cpx_base::parse_tcl_command(arg);
}

