/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_file.cc"
 *								   created:		1/30/95	{11:26:12 am}
 *								   last	update:	10/12/96 {1:10:48 am}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "info_file.h"
#include <fstream.h>
#include "util.h"
#include <string.h>

const char * info_file::_type = "Info File";

info_file::info_file(const char* tcl_name, cpx_with_info* container)
	:info_base(tcl_name, container)
{
	find_static_part(tcl_name);
	_file_name = 0;

}

s_info_base* info_file::new_static(const char* n) {
	return new s_info_file(n);
}

const char* info_file::file_name(void) const {
    return _file_name;
}

bool info_file::can_add(const char* /* type */) const{
	return false;
}

bool info_file::ready(void) const {
    if(_file_name)
		return info_base::ready();
    else
		return false;
}

cpx_error info_file::add_info(info_base*) {
    // assumes that you can be added, and that you have already
    // set your container to point to me
    return cpx_error::OK;
}

cpx_error info_file::remove_info(info_base*) {
	// assumes that you know your container is no longer
	// going to be me
	return cpx_error::OK;
}

ostream& info_file::write_to_stream(ostream& o) {
	if(_file_name){
		o << _file_name;
	}
	return o;
}

istream& info_file::read_from_stream(istream& i) {
	if(_file_name)
		close_file();
	char buf[60];
	i >> buf;
	set_file(buf,false);
	return i;
}

int info_file::parse_tcl_command(tcl_args& arg){	
	if ((arg("","return the currently owned file")=="getFile")
			   || (arg("")=="get")) {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		// return my file
		tcl_ << (*this) << result;
		return TCL_OK;
	} else if (arg("","closes the currently owned file")=="closeFile") {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		if(!_file_name){
			tcl_ << get_tcl_command() << ":I have no file." << tcl_error;
			return TCL_ERROR;
		}
		close_file();
		return TCL_OK;
	} else if ((arg("name","set name of file for data i/o")=="setFile")
			   || (arg("name")=="set")
			   || (arg("name")=="=")) {
		// if I have a file name already, signal an error
		arg >> arg.tmp_chars;
		bool append = false;
		const char *app =0;
		arg >> optional >> app >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);		
		if(app && !strcmp(app,"append")) {
			append = true;
		}
		// set_file makes a copy of the name
		if(_file_name){
			tcl_ <<  get_tcl_command() 
				 <<  ":You must close my file first." << tcl_error;
			return tcl_;
		}
		set_file(arg.tmp_chars,append);
		tcl_ << arg.tmp_chars << result;
		return TCL_OK;
	} else  // if we don't recognize the command, see if info_base does
		return info_base::parse_tcl_command(arg);
}

