/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_gatherer.cc"
 *								   created:		1/24/95	{7:25:24 pm}
 *								   last	update:	26/6/96 {3:18:53 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "info_gatherer.h"
#include "info_source.h"
#include "cpx_object.h"
#include <string.h>
#include "object_control.h"

info_gatherer::info_gatherer(const char* tcl_name, cpx_with_info* container)
	:info_base(tcl_name, container)
{
	find_static_part(tcl_name);
	_source_name = 0;
	quick_lookup = -1;
	quick_ref_source = 0;
	quick_ref_type = 0;
	scaled = false;
	temp = 0;
}

s_info_base* info_gatherer::new_static(const char* n) {
	return new s_info_gatherer(n);
}

const char * info_gatherer::_type = "Info Gatherer";	

bool info_gatherer::ready(void) const  {
	return (_source_name != 0 ? true : false);
}

void info_gatherer::finish_adding(info_observable* s) {
	_source_name = s->name(); 
	// find the reference to the source
	quick_lookup = s->get_quick_index();
	
	quick_ref_source = s->my_quick_ref();
	if(quick_ref_source)
	    quick_ref_type = s->container->type();
	archive() << get_tcl_command() << " connect " << s->get_tcl_command() << endl;

}	

void info_gatherer::use_object(const cpx_object* obj){
    temp = obj;
}

void info_gatherer::finish_removing(info_observable* s) {
	_source_name = 0; 
	quick_lookup = -1;
	quick_ref_source = 0;
	quick_ref_type = 0;
	archive() << get_tcl_command() << " disconnect " 
			  << s->get_tcl_command() << endl;
	
}	

int info_gatherer::parse_tcl_command(tcl_args& arg){	
  	if (arg("","return name of attached source")=="getContents") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
  		if (_source_name)
      		tcl_ <<  _source_name << result;
    	return TCL_OK;
  	} else if (arg("","is this data collector scaled?")=="getScaled") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
	  	if(scaled == true)
			tcl_ << "true" << result;
	  	else
			tcl_ << "false" << result;
	    return TCL_OK;
	} else if (arg("value","set state of data-collection scaling")
				=="setScaled") {
		bool val;
		arg >> val >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		scaled = val;
	  	archive() << get_tcl_command() << " setScaled " << BOOL val << endl;
	  	return TCL_OK;
	} else  // if we don't recognize the command, see if cpx_object does
    	return info_base::parse_tcl_command(arg);
}

bool info_src_gatherer::can_add(const char* t) const{
	return(maycast(t,info_source));
}

cpx_error info_src_gatherer::add_info(info_base* obj){ 
	info_source* s = ckcast(obj,info_source);
	if(!s) {
		return cpx_error(cpx_error::WARNING,"Tried to add object which wasn't a source");
	}
	
    // SHOULD CHECK IF WE ALREADY HAVE ONE
	source = s;
	finish_adding(s);
	return cpx_error::OK;
}	

cpx_error info_src_gatherer::remove_info(info_base* obj){
	info_source* i = ckcast(obj,info_source);
	
	if(i != 0 && _source_name == i->name()) {
		source = 0;
		finish_removing(i);
		return cpx_error::OK;
	} else  {
		return cpx_error(cpx_error::ERROR,"I don't contain that object.");
	}
	
}	






