/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_socket.cc"
 *								   created:		1/24/95	{7:27:10 pm}
 *								   last	update:	26/6/96 {3:19:19 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "object_control.h"
#include "info_socket.h"
#include "info_event.h"
#include "string.h"

const char * info_socket::_type = "Info Socket";

info_socket::info_socket(const char* tcl_name, cpx_with_info* container, socket_fn f)
	:info_triggerer(tcl_name, container)
{
	find_static_part(tcl_name);
	((s_info_socket*)s_me)->socket = f;
}

s_info_base* info_socket::new_static(const char* n) {
	return new s_info_socket(n);
}

void info_socket::call(cpx_with_info* obj) {
    //assert(container);
    (container->*( ((s_info_socket*)s_me) ->socket) )(obj);
    trigger();
}

bool info_socket::can_add(const char* t) const{
    if(maycast(t,info_event))
		return true;
    else
		return info_triggerer::can_add(t);
}

bool info_socket::ready(void) const  {
    return (requestees.isNonEmpty() ? true : false);
}

cpx_error info_socket::register_event(info_triggerer* obj) {
    requestees.append(obj);
    return cpx_error::OK;
}

cpx_error info_socket::deregister_event(info_triggerer* obj) {
    requestees.remove(obj);
    return cpx_error::OK;
}

cpx_error info_socket::add_info(info_base* base) {
    if (info_event* e = ckcast(base,info_event))
		return e->add_info(this);
    else
		return info_triggerer::add_info(base);
}

cpx_error info_socket::remove_info(info_base* base) {
    if (info_event* e = ckcast(base,info_event))
		return e->remove_info(this);
    else
		return info_triggerer::remove_info(base);
}

void info_socket::deregister_myself(void) {
    // loop over my list of requestees and call them
    // note my remove_object function above will be called each time
    list_pos<info_triggerer*> scanner = requestees.head();
    
    while((scanner = requestees.head()).onlist()) {
		scanner.item()->remove_info(this);
    }
}

info_socket::~info_socket(void) {
	//de-register myself from everyone
	deregister_myself();
}

int info_socket::parse_tcl_command(tcl_args& arg){	
    if (arg("","list all connected triggering events")=="getContents") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		// Note this could return nothing at all
		for(list_pos<info_triggerer*> s = requestees;s;++s) {
			tcl_ <<  s.item()->get_tcl_command() << lappend;
			
		}
		return TCL_OK;
    } else if (arg("event","form connection with a given event")=="connect") {
	    info_triggerer* i;
	    arg >> i >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		add_info(i);
		return TCL_OK;
    } else if (arg("event","remove connection with a given event")=="disconnect") {
	    info_triggerer* i;
	    arg >> i >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		remove_info(i);
		return TCL_OK;
    } else  // if we don't recognize the command, see if info_triggerer does
		return info_triggerer::parse_tcl_command(arg);
}

