/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_fn.cc"
 *									  created: 7/26/95 {9:28:11	PM}	
 *								  last update: 9/12/96 {2:15:20 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#ifdef DEFINE_TEMPLATES

#include "info_source_fn.h"


// construction
template <class T>
info_source_fn<T>::info_source_fn(const char* tcl_name, cpx_with_info* container
                                  , T (cpx_with_info::*read)(void)
                                  , void (cpx_with_info::*write)(T)
                                  , quick_ref ref)
:info_source_t<T>(tcl_name,container){
	find_static_part(tcl_name);
	((s_info_source_fn<T>*)s_me)->read_fn = read;
	((s_info_source_fn<T>*)s_me)->write_fn = write;
	((s_info_source*)s_me)->pointer_to_me = ref;
}

template <class T>
s_info_base* info_source_fn<T>::new_static(const char* n) {
	return new s_info_source_fn<T>(n);
}

// construction
template <class T>
info_source_ref_fn<T>::info_source_ref_fn(const char* tcl_name, 
								  cpx_with_info* container, 
								  T& (cpx_with_info::*reffn)(void), 
								  quick_ref ref)
:info_source_t<T>(tcl_name,container){
	find_static_part(tcl_name);
	((s_info_source_ref_fn<T>*)s_me)->ref = reffn;
	((s_info_source*)s_me)->pointer_to_me = ref;
}

template <class T>
s_info_base* info_source_ref_fn<T>::new_static(const char* n) {
	return new s_info_source_ref_fn<T>(n);
}

#endif