/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_source_t.cc"
 *								   created:		1/24/95	{7:06:15 pm}
 *								   last	update:	19/7/96 {3:13:05 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#ifdef DEFINE_TEMPLATES

#include "info_source_t.h"
#include "cpx_object.h"
#include "util.h"
#include "info_gatherer.h"
#include <string.h>
#ifdef __MWERKS__
#include <sstream>

/*
istream& operator >> (istream& i, bool& b) {
	char buf[20];
	i >> buf;
	if(!strcmp(buf,"false")){
		b = false;
		return i;
	} else if(!strcmp(buf,"true")){
		b = true;
		return i;
	} else {
		strstream s;
		s << buf << ends;
		short t;
		s >> t;
		if(s.fail()) {
			// set the real input stream to a failed state
			// We didn't convert what we were given either
			// to a given item or to an integer.
			i.setstate(ios::failbit);
		} else {
			b = (t ? true : false);
		}
		return i;
	}	
}

ostream& operator << (ostream& o, bool b) {
	if(b) {
		o << "1";
	} else {
		o << "0";
	}
	return o;
}
*/
#endif


template <class T>
T limit_var<T>::value(const cpx_with_info* read_from) const{
    return *((info_source_t<T>*)(read_from->information(_name)));
}

template<class T>
limit_var<T>::limit_var(const char* _n):itemised(false),_name(_n){
}

// minima
template <class T>
info_source_t<T>& info_source_t<T>::min(T t) { 
    if(_min() ==0)
		_min() = new limit_fixed<T>(t);
    return *this;
}
template <class T>
info_source_t<T>& info_source_t<T>::minv(const char* mn) { 
    if(_min () ==0){
		// find the actual name, not this "copy"
		info_observable* ii = read_from_object()->slow_information(mn);
		if(!ii){
			error(0) << "Couldn't find variable min limit:" << mn << ends;
			return *this;
		}		
		_min() = new limit_var<T>(ii->name());
	}
    return *this;
}
// maxima
template <class T>
info_source_t<T>& info_source_t<T>::max(T t) { 
    if(_max() ==0)
		_max() = new limit_fixed<T>(t);
    return *this;
}
template <class T>
info_source_t<T>& info_source_t<T>::maxv(const char* mx) { 
    if(_max () ==0){
		// find the actual name, not this "copy"
		info_observable* ii = read_from_object()->slow_information(mx);
		if(!ii){
			error(0) << "Couldn't find variable max limit:" << mx << ends;
			return *this;
		}		
		_max() = new limit_var<T>(ii->name());
	}
    return *this;
}
// itemised list
info_source_t<bool>& info_source_t<bool>::itemised(const char* i)  { 
    if(_min() == 0 && _max() == 0) {		
		const char* items = i;
		short max_count = 0;
		for(;*i; i += strlen(i)+1) {
			max_count += 1;
		}
		if(max_count >2) {
			// error
			// throw exception when they're properly supported
		}
		bool maxb = (max_count == 2 ? true : false);
		_min() = new limit_fixed<bool>(false);
		_max() = new limit_fixed<bool>(maxb,items);
    }
    return *this;
}
// itemised list
template <class T>
info_source_t<T>& info_source_t<T>::itemised(const char* i)  { 
    if(_min() == 0 && _max() == 0) {		
		T max_count = (T) 0;
		const char* items = i;
		for(;*i; i += strlen(i)+1) {
			max_count += 1;
		}
		_min() = new limit_fixed<T>((T)1);
		_max() = new limit_fixed<T>((T)max_count,items);
    }
    return *this;
}

template <class T>
void info_source_t<T>::make_info_gatherer(cpx_with_info* e) {
	// gets added in to 'e' in the base constructor
    const char* new_name = mystrdup(type());
    // create a new gatherer, and add myself to it straight-away
    (new info_gatherer_<T>(new_name, e))->add_info(this);
}

// for info gatherers
template <class T>
bool info_source_t<T>::scale(void){
    return false;
} 
template <class T>
bool info_source_t<T>::scale(short&,short&){
    return false;
} 
template <class T>
bool info_source_t<T>::scale(float&,float&){
    return false;
} 

template <class T>
bool info_source_t<T>::is_itemised(void) const {
    if(_max())
		return _max()->itemised();
    else 
		return false;
} 

template <class T>
const char* info_source_t<T>::items(void) const {
    if(is_itemised())
		return _max()->items();
    else 
		return 0;
} 

template <class T>
void info_source_t<T>::minmax(short& mn,short& mx) const {
	if(_min()) mn = (short) _min()->value(read_from_object());
	if(_max()) mx = (short) _max()->value(read_from_object());		
}

template <class T>
void info_source_t<T>::minmax(long& mn,long& mx) const {
	if(_min()) mn = (long) _min()->value(read_from_object());
	if(_max()) mx = (long) _max()->value(read_from_object());		
}

template <class T>
void info_source_t<T>::minmax(float& mn,float& mx) const {
	if(_min()) mn = (float) _min()->value(read_from_object());
	if(_max()) mx = (float) _max()->value(read_from_object());		
}

template <class T>
void info_source_t<T>::minmax(double& mn,double& mx) const {
	if(_min()) mn = (double) _min()->value(read_from_object());
	if(_max()) mx = (double) _max()->value(read_from_object());		
}

template <class T>
void info_source_t<T>::minmax(char& mn,char& mx) const {
	if(_min()) mn = (char) _min()->value(read_from_object());
	if(_max()) mx = (char) _max()->value(read_from_object());		
}

template <class T>
void info_source_t<T>::minmax(bool& mn,bool& mx) const {
	if(_min()) mn = (bool) _min()->value(read_from_object());
	if(_max()) mx = (bool) _max()->value(read_from_object());		
}

template <class T>
void info_source_t<T>::hasminmax(bool& mn,bool& mx) const{
	mn = (_min() ? true : false );
	mx = (_max() ? true : false );
} 


template <class T>
void info_source_t<T>::get(short& val){
	val = (short)(T)(*this);
} 
template <class T> // what do these all do?
void info_source_t<T>::get(short&,short,short){
} 
template <class T>
void info_source_t<T>::get(long& val){
	val = (long)(T)(*this);
} 
template <class T>
void info_source_t<T>::get(long&,long,long){
} 
template <class T>
void info_source_t<T>::get(float& val){
	val = (float)(T)(*this);
} 
template <class T>
void info_source_t<T>::get(float&,float,float){
} 
template <class T>
void info_source_t<T>::get(double& val){
	val = (double)(T)(*this);
} 
template <class T>
void info_source_t<T>::get(double&,double,double){
} 
template <class T>
void info_source_t<T>::get(bool& val){
	val = (bool)(T)(*this);
} 
template <class T>
void info_source_t<T>::get(bool&,bool,bool){
} 
template <class T>
void info_source_t<T>::get(char& val){
	val = (char)(T)(*this);
} 
template <class T>
void info_source_t<T>::get(char&,char,char){
} 

istream& info_source_t<bool>::read_from_stream(istream& istr) {
	bool t;
	istr >> t;
	operator= (t);
	return istr;
}

template <class T>
istream& info_source_t<T>::read_from_stream(istream& istr) {
	if(is_itemised()) {
		char buf[20];
		istr >> buf;
		// we start the count from 1
		T item_count = 1;
		// try to find it directly
		for(const char* i = items();*i;i+= strlen(i)+1) {
			if(!strcmp(i,buf)) {
				// got match;
				operator = (item_count);
				return istr;
			}
			item_count++;
		}
		// try to find it with underscores->spaces
		for(unsigned short ii=0;ii<strlen(buf);ii++) {
			buf[ii] = (buf[ii] == '_' ? ' ' : buf[ii] );
		}
		item_count = 1;
		for(const char* i = items();*i;i+= strlen(i)+1) {
			if(!strcmp(i,buf)) {
				// got match;
				operator = (item_count);
				return istr;
			}
			item_count++;
		}
		// BACKWARDS COMPATIBILITY: code may vanish
		// (and turn to: istr.setstate(ios::failbit);)
		// maybe it was a number, (that's bad really),
		// but we do this for backwards compatibility.
		// For best use we pull from a stream.
		strstream s;
		s << buf << ends;
		T t;
		s >> t;
		if(s.fail()) {
			// set the real input stream to a failed state
			// We didn't convert what we were given either
		    // to a given item or to an integer.
		    istr.setstate(ios::failbit);
		} else {
			operator=(t);
		}
	} else {
		T t;
		istr >> t;
		if(in_range(t)) {
			operator= (t);
		} else {
		    istr.setstate(ios::failbit);			
		}
	}	
	return istr;
}

bool info_source_t<bool>::in_range(bool) {
	return true;
}

template <class T>
bool info_source_t<T>::in_range(T val) {
	T mint, maxt;
	bool havemin, havemax;
	hasminmax(havemin,havemax);
	minmax(mint,maxt);	
	if((havemin && mint > val) || (havemax && maxt < val)) {
		 return false;
	} else {
		return true;
	}
}

ostream& info_source_t<bool>::write_to_stream(ostream& o) {
	bool t;
	t = (*this);
	o << t;
	return o;
}

template <class T>
ostream& info_source_t<T>::write_to_stream(ostream& o) {
	T t;
	t = (*this);
	if(is_itemised()) {
		const char* i;
		// items start at 1, not zero.
		for(i = items();t>1;i+= strlen(i)+1) {
			t--;
		}
		for(unsigned short ii=0;ii<=strlen(i);ii++) {
			o << (i[ii] == ' ' ? '_' : i[ii] );
		}
	} else {
		o << t;
	}
	return o;
}

template <class T>
void info_source_t<T>::conversion_error(tcl_args& arg) {
	ostrstream obuf;
	// this 'ends' signals both that this is a special conversion 
	// error and that the caller must free the string returned.
	obuf << ends;
	if(is_itemised()) {
		obuf << "to any of: ";
	} else {
		obuf << "to the range: ";
	}
	list_items(obuf);
	obuf << ends;
	arg.set_conversion_type(obuf.str());
	arg.syntax("value");
}

template <class T>
void info_source_t<T>::list_items(ostream& obuf) const {
	if(is_itemised()) {
		// the syntax isn't just 'value', but rather one of a 
		// specific set of strings:
		for(const char* i = items();*i;i+= strlen(i)+1) {
			for(unsigned short c=0;c<strlen(i);c++) {
				obuf << (i[c] == ' ' ? '_' : i[c] );
			}
			obuf << " ";
		}
	} else {
		T mint, maxt;
		bool havemin, havemax;
		hasminmax(havemin,havemax);
		minmax(mint,maxt);	
		if(havemin) {
			obuf << "[" << mint;
		} else {
			obuf << "[-infinity";		
		} 
		obuf << ",";
		if(havemax) {
			obuf << maxt;
		} else {
			obuf << "infinity";	
		} 
		obuf << "]";
	}
}

template <class T>
int info_source_t<T>::parse_tcl_command(tcl_args& arg){	
    if (arg("","returns current value of this variable")=="getValue" 
    			|| arg("")=="get") {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		tcl_ << (*this);
		tcl_ << result;
		return TCL_OK;
	} else if ((arg("value","sets this variable to the given value")=="setValue") 
	           || (arg("value")=="=")
	           || (arg("value")=="set")){
		char* ibuf=0;
		if(is_itemised()) {
			// the syntax isn't just 'value', but rather one of a 
			// specific set of strings:
			ostrstream item_buf;
			item_buf << "value (any of: ";
			list_items(item_buf);
			item_buf << ")" << ends;
			ibuf = item_buf.str();
			arg.syntax(ibuf);
		}
		// have to be careful of 'ibuf' memory leak.  I think this is ok,
		// but am not 100% sure (esp. with exceptions).
	  	arg >> (*this);
	  	if(is_itemised() && ibuf) delete ibuf;
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
	  	archive() << get_tcl_command() << " setValue " << arg.orig_argv(arg.orig_argc()-1) << endl;
		tcl_ << (*this) << result;
	  	return TCL_OK;
    } else if (arg("","find lower limit on this variable")=="getMin") {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		if(_min()){
		    ostrstream str;
		    tcl_ << (T) _min()->value(read_from_object()) << result;
		} else {
		    tcl_ << "no limit" << result;
		}
		return TCL_OK;
    } else if (arg("","find upper limit on this variable")=="getMax") {
	  	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		if(_max()){
		    ostrstream str;
		    tcl_ << (T) _max()->value(read_from_object()) << result;
		} else {
		    tcl_ << "no limit" << result;
		}
		return TCL_OK;
    } else  // if we don't recognize the command, see if info_source does
		return info_source::parse_tcl_command(arg);
}

#endif
