/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_var.cc"
 *									  created: 7/26/95 {9:28:27	PM}	
 *								  last update: 11/5/96 {9:17:06 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#ifdef DEFINE_TEMPLATES

#include "info_source_var.h"

template <class T>
info_source_v<T>::info_source_v(const char* tcl_name,
				    			cpx_with_info* container,
				    			quick_ref ref)
    :info_source_t<T>(tcl_name,container){
	find_static_part(tcl_name);
	((s_info_source*)s_me)->pointer_to_me = ref;
}

template <class T>
bool info_source_v<T>::ready(void) const {
    T t = (*this);
    if(_min() && (_min()->value(container) > t)) return false;
    if(_max() && (_max()->value(container) < t)) return false;
    
    return info_source::ready();

}

template <class T>
s_info_base* info_source_v<T>::new_static(const char* n) {
    return new s_info_source_var<T>(n);
}

template <class T>
info_source_var<T>::info_source_var(const char* tcl_name,
                                    cpx_with_info* container,
                                    quick_ref ref)
    :info_source_v<T>(tcl_name,container,ref){
}

template <class T>
info_source_var_ref<T>::info_source_var_ref(const char* tcl_name,
                                            cpx_with_info* container, 
                                            T& vref,
                                            quick_ref ref)
    :info_source_v<T>(tcl_name,container,ref),ref_t(vref){
}

 
#endif