/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_vars.cc"
 *									  created: 11/5/96 {4:38:06	pm}	
 *								  last update: 6/6/96 {11:03:09 am}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#ifdef DEFINE_TEMPLATES

#include "info_source_vars.h"

#ifdef __GNUC__
template <class T>
info_var<T>::info_var(void) {}
template <class T>
info_var<T>::~info_var(void) {}
template <class T>
info_var<T>::info_var(info_var<T>&) {}
#endif

template <class T>
info_source_var_indirect<T>::info_source_var_indirect(const char* tcl_name,
						    cpx_with_info* container,
						    cpx_with_info* info_from,
						    const info_var<T>& i,
						    quick_ref ref)
    :info_source_t<T>(tcl_name,container){
		
	find_static_part(tcl_name);
	s_info_source_var_indirect<T>* s = (s_info_source_var_indirect<T>*) s_me;
	//s->info_from = info_from;
	
	s->var_ = i.var();
	s->pointer_to_me = ref;
	this->info_from = info_from;
}

template <class T>
s_info_base* info_source_var_indirect<T>::new_static(const char* n) {
    return new s_info_source_var_indirect<T>(n);
}

#endif

