/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "Demofour.h"
 *									  created: 9/12/96 {8:06:25	pm}	
 *								  last update: 9/12/96 {8:09:49 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@deas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	9/12/96	 VMD 1.0 original
 * ###################################################################
 */

#ifndef _EvoX_siteswap_
#define _EvoX_siteswap_

#include "CppTclExtraInclude.h"

struct juggle_flags {
	short	ground, numonly, sequence, irred,
			oneone, rhythm, number, maxThrow,
			pattLen, multiplex, streams;
};

const  short ASYNCH_SOLO   =   1;
       /* different types of modes */
const  short SYNCH_SOLO     =  2;

const  short ASYNCH_PASSING  = 3;

const  short CUSTOM        =   4;
 

/*
const MaxStreams	4
const MaxThrow	11
const MaxLength	11
const MaxSlotSize 13
const MaxBalls	11
const MaxMplex	4
*/


//const  BUFFER_SIZE      160     /* # of chars. in file input buffer */
const  short CHARS_PER_THROW =  10;     /* max. # of chars. printed per throw */

struct jthrow {                    /* records throw information */
   short to;                            /* destination hand # */
   short height;                         /* total time ticks aloft */
};

struct filter {                   /* multiplexing filter slot entry */
   short type;                          /* type of entry */
   short from;                          /* source hand # */
   short height;                         /* total time ticks aloft */
};

const  short EMPTY     =       0  ;     /* types of multiplexing filter slots */
const  short THROW      =      1;
const  short LOWER_BOUND  =    2;

class siteswap: public cpx_with_info {
  public:
	// we need to know our interpreter and the name of our tcl command
	siteswap(tcl_args&);
	static const char* _type;
	cpx_type type(void) const {return _type;}
	
  	~siteswap(void);

   /* 
	* we must supply this function so 'siteswap' can do something. it looks through
	* the arguments	and	does whatever it wants.	 the intention is for 
	* parse_tcl_command	to decide which	member function	to call, 
	* prepare the arguments	to that	member function	(perhaps 
	* converting strings to	ints or	suchlike), then	call the member	
	* function to do the actual	work.  parse_tcl_command should	just 
	* be a parser, as the name implies.
	*/

    int parse_tcl_command(tcl_args& arg);
	static tcl_object* make_new(tcl_args& arg) {
		return new siteswap(arg);
	}

  protected:
  	
   /* The class siteswap manipulates these patterns */
	
   public:
 	info_source_var<short> ground;
 	info_source_bool numonly;
 	info_source_bool irred;
 	info_source_bool allow_oneone;
 	info_source_var<short> rhythm;
 	info_source_var<short> number;
 	info_source_var<short> maxThrow;
 	info_source_var<short> pattLen;
 	info_source_var<short> multiplex;
 	info_source_var<short> streams;
 	info_source_var<long> total_num;
 	
	short		rhythm_repunit[2][2],
				rhythm_period;	

  protected:	
	short	print_width;
	void set_rhythm(void);
  public:
 	virtual bool find_ground(void);
	virtual void print_streams(void);
	virtual void print_pattern(ostream&);
	virtual bool check_pattern(void);
	virtual void make_rhythm(void);
	virtual bool find_next_possible(short position, short stream, short mplex_slot, short remainder);
  
 protected:
	char * starting_seq;
	char* ending_seq;
	short** pattern_catch;
	short *** ground_rhythm;
	short *** pattern_rhythm;
	jthrow*** pattern_throw;
	
   	virtual bool excited(void);
   	virtual bool pattern_increment(short& p, short& s, short& m, short& r);
   	virtual char *print_number(char *pos, short number);
   	virtual char *print_throw(char *pos, jthrow**, short**);
  
    bool *oneone, *old_oneone;
    
	/* virtual short valid_throw(short pos); */
	/* virtual short valid_pattern(void); */
	/* virtual short mp_addthrow(struct filter *dest_slot, short slot_hand, short type, short height, short from); */
	/* virtual void find_start_end(void); */

  private:
	void delete_arrays(void);
	void declare_arrays(void);
	
};


#endif
