/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpxTutorial.h"
 *									  created: 9/12/96 {12:11:59 pm} 
 *								  last update: 9/12/96 {12:43:21 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<vince@deas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	9/12/96	 VMD 1.0 original
 * ###################################################################
 */

#ifndef _cpxTutorial_
#define _cpxTutorial_

// Only necessary on MacOS
#include "Cpptcl.h"
/* 
 * -------------------------------------------------------------------------
 *   
 * "A" --
 *  
 *  Class with:
 *   trivial constructor,
 *   a single member function,
 *   no data members.
 *   
 *  Since we have no data members, we need only use 'cpptcl', not
 *  'cpptclextra' if desired.  Notice how we've added a piece of
 *  help text with the triple comment '///'.  If we did (in Tcl)
 *  the following: 'A a ; a foo -help' we are returned that segment
 *  of help text.
 * -------------------------------------------------------------------------
 */
class A {
  public:
	A(void);
	~A(void);
	
	/// solves the world's problems
	void foo(void);
};

/* 
 * -------------------------------------------------------------------------
 *   
 * "B" --
 *  
 *  Class with:
 *   trivial constructor,
 *   a single member function,
 *   a data member.
 *   
 *  If we want the data member to be visible in Tcl, we must use the 
 *  'cpptclextra' library to wrap this class (alternatively, we could
 *  add a 'set' and a 'read' member function and expose 'b' in that way;
 *  then we wouldn't have to use the extra capabilities of 'cpptclextra')
 * -------------------------------------------------------------------------
 */
class B {
  public:
	B(void);
	~B(void);
	
	float b;
	void foo(void);
};

/* 
 * -------------------------------------------------------------------------
 *   
 * "C" --
 *  
 *  Class with:
 *   trivial constructor,
 *   a variety of data members and member functions.
 *  
 *  This is a more complex class, with member functions which both return
 *  values and have arguments.  Cpptcl handles all of this automatically.
 *  Since we have a large number of data members, if we want to expose them
 *  to Tcl, we ought to use 'cpptclextra'.  This also lets us do things like
 *  this:
 *    tclsh
 *    % C c    # creates object of type 'C'
 *    c
 *    % c configure -c1 1.23 -c4 true -c2 -0.35 -c3 353
 *    353
 *    % c getContents
 *    ...
 *  
 * -------------------------------------------------------------------------
 */
class C {
  public:
	C(void);
	~C(void);
	
	float c1;
	double c2;
	short c3;
	short c4;
	
	void foo1(void);
	long foo2(long a, long b);
	float foo3(void);
};

/* 
 * -------------------------------------------------------------------------
 *   
 * "D" --
 *  
 *  Class with:
 *   non-trivial constructor,
 *   data and function members.
 *   
 *  With a non-trivial constructor, the process of deriving argument values
 *  from Tcl requires that the object is indirectly derived.  So wrapped
 *  object 'D_tcl' contains a pointer to a 'D', and automatically initialises
 *  and destroys that pointer for us.  This is transparent to the user, but
 *  perhaps useful for those interested in implementation.
 * -------------------------------------------------------------------------
 */
class D {
  public:
	D(long d1, float d2);
	~D(void);
	
	short d3;
	bool foo(bool d);
};

#endif

