package require Cpptcl
package require Itcl

itcl::class cpx::ClassBrowser {
    inherit cpx::WindowTree 

    constructor {args} {}
    
    method makeHierarchy {} { pure_virtual }
    method addObjectAndDescendants {obj} {pure_virtual}
    method addPair {obj parent} {}
    method niceName {obj} {}
	method setNodeType {type} {}
	public variable nodeType "cpx::TIplain"
}

body cpx::ClassBrowser::constructor {args} {
	set mb $itk_component(mbar).configure
	$mb.menu add cascade -label "Node Type" \
		-menu $mb.menu.ntmenu
	set m [menu $mb.menu.ntmenu]
	global ::cpx::options
	foreach d $options(classdisplays) {
		$m add command -label "$d" \
			-command [code $this setNodeType "cpx::TI${d}"]
	}
	#makeHierarchy
}

body cpx::ClassBrowser::setNodeType {type} {
	# should check if descended from correct thing
	set nodeType $type
	myHierarchy clear
	makeHierarchy
}

body cpx::ClassBrowser::addPair {obj parent} {
	set objname [niceName $obj]
	set item [myHierarchy theCanvas].a$objname
	if {[info commands $item] == ""} {
		set parent [niceName $parent]
		$nodeType $item $obj [myHierarchy theCanvas] -text "$obj"
		myHierarchy add $item $objname $parent	
	}
	
}

body cpx::ClassBrowser::niceName {obj} {
	regsub -all "::" [join $obj ""] "-" obj
	return $obj
}

class cpx::CpptclClassBrowser {
    inherit cpx::ClassBrowser cpx::ObjectControl

    constructor {args} {}
    
    method makeHierarchy {} {}
    method addObjectAndDescendants {obj} {}
}

body cpx::CpptclClassBrowser::constructor {args} {
	wm title [info namespace tail $this] "Cpptcl Class Browser"
}

body cpx::CpptclClassBrowser::makeHierarchy {} {
	foreach base [cpptclControl listTypes] {
		addObjectAndDescendants $base
	}
	update
	myHierarchy draw
}

body cpx::CpptclClassBrowser::addObjectAndDescendants {obj} {
	set objname [join $obj ""]
	set item [myHierarchy theCanvas].a$objname
	$nodeType $item $obj [myHierarchy theCanvas] -text "$obj"
	foreach parent [cpptclControl listParents $obj] {
		if {$parent == "All Objects" } { 
			set parent "" 
		} else {
			set parent [join $parent ""]
		}
		myHierarchy add $item $objname $parent
	}
	foreach descendant [cpptclControl listTypes $obj] {
		addObjectAndDescendants $descendant
	}
}

class cpx::ItclClassBrowser {
    inherit cpx::ClassBrowser 

    constructor {args} {}
    
    method makeHierarchy {} {}
    method addObjectAndDescendants {obj} {}
    method addObjectAndParents {obj} {}
}

body cpx::ItclClassBrowser::constructor {args} {
	wm title [info namespace tail $this] "Itcl Class Browser"
}

body cpx::ItclClassBrowser::makeHierarchy {} {
	foreach base [uplevel \#0 info classes *] {
		addObjectAndParents $base
	}
	update
	myHierarchy draw
}

body cpx::ItclClassBrowser::addObjectAndParents {obj} {
    if {[catch {uplevel \#0 namespace $obj \{info inherit\}} inherit] == 0} {
    	foreach parent $inherit {
    		addObjectAndParents $parent
    		addPair $obj $parent
    	}
    	if {$inherit == ""} {
    		addPair $obj ""
    	}
	}
}

body cpx::ItclClassBrowser::addObjectAndDescendants {obj} {
	return
	set objname [join $obj ""]
	set item [myHierarchy theCanvas].a$objname
	$nodeType $item $obj [myHierarchy theCanvas] -text "$obj"
	foreach parent [info listParents $obj] {
		if {$parent == "All Objects" } { 
			set parent "" 
		} else {
			set parent [niceName $parent]
		}
		myHierarchy add $item $objname $parent
	}
	foreach descendant [info descendants $obj] {
		addObjectAndDescendants $descendant
	}
}
