## -*-Tcl-*-
 # ###################################################################
 #	Cpptcl - integrating C++ with Tcl
 # 
 #	FILE: "cppItcl.tcl"
 #									  created: 18/8/96 {11:25:08 am} 
 #								  last update: 18/8/96 {12:10:31 pm} 
 #	Author:	Vince Darley
 #	E-mail:	<vince@das.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 # 
 #  modified by  rev reason
 #  -------- --- --- -----------
 #  18/8/96  VMD 1.0 original
 # ###################################################################
 ##



## 
 # -------------------------------------------------------------------------
 #	 
 # "generateItcl" --
 #	
 #	Create an Itcl wrapper class for a Cpptcl class	or object.	If you
 #	pass in	a 'classname' it is	assumed	the	'name' refers to a unique
 #	object to wrap.	 If	no classname is	given, it is assumed 'name'
 #	refers to a	Cpptcl class, and a	trial object is	created, and a 
 #	wrapper	for	the	general	class is constructed
 #		   
 # Results:
 #	Outputs	a file with	the	wrapper.
 #	
 # Side	effects:
 #	Needs to create	an object instance for a general class.	 If	your
 #	objects	can	only be	created	under particular circumstances,	that
 #	makes things a bit awkward.	 Will be fixed in due course.
 # -------------------------------------------------------------------------
 ##
proc generateItcl {name {classname ""}} {
	if {$classname == ""} {
		set classname $name
		$classname _trial
		set trial _trial
		set nocreate 0
	} else {
		set trial $name
		set nocreate 1
	}
	set docs [split [documentObject $trial] "\n\r"]
	set fout [open [join ${classname}].tcl w]
	puts $fout "## -*-Tcl-*-"
	puts $fout " # ###################################################################"
	puts $fout " #  FILE: \"[join ${classname}].tcl\""
	puts $fout " #"
	puts $fout " #  Automatically generated by Cpptcl system."
	puts $fout " #"
	puts $fout " # ###################################################################"
	puts $fout " ##"
	puts $fout ""

	puts $fout "itcl::class I${classname} \{"
	if {$nocreate} {
		puts $fout "\tconstructor \{args\} \{"
		puts $fout "\t\}"
		puts $fout ""
		puts $fout "\tdestructor \{\}"
		set obj "$trial"
	} else {
		puts $fout "\tconstructor \{args\} \{"
		puts $fout "\t\t${classname} _this"
		puts $fout "\t\}"
		puts $fout ""
		puts $fout "\tdestructor \{\} \{ rename _this \{\} \}"
		set obj "_this"
	}
	puts $fout ""
	
	
	foreach method $docs {
		set lm [split $method ":"]
		set cmd [lindex [lindex $lm 0] 1]
		if { $cmd != "" } {
			puts $fout "\tpublic method ${cmd} \{args\} \{"
			puts $fout "\t\teval ${obj} ${cmd} \${args}"
			puts $fout "\t\}"
			puts $fout ""
		}
	}
	puts $fout "\}"
	puts $fout ""
	flush $fout
	close $fout
}




