
proc cpx::completion {commandLine} {
	set comp [eval cpptcl complete $commandLine]
	switch [lindex $comp 0] {
		case "Completions:" {
			set common [cpptcl maxCompletion]
			if { $common != "" } {
				insertText $common
				return ""
			} else {
				beep
				return $comp
			}
		}
		case "No" {
			beep
			return ""
		}
		case "Already" {
			beep
			return ""
		}
	}
}

proc cpx::documentObject {obj} {
	set cmds [lrange [split [cpptcl complete $obj] "\n"] 1 end]
	set doc {}
	foreach f $cmds {
		catch {eval $f -h} d
		append doc "${d}\n"
	}
	return $doc
}
