## -*-Tcl-*-
 # ###################################################################
 #	CppTclExtra
 # 
 #	FILE: "Cpptclextra.tcl"
 #									  created: 21/6/96 {10:27:14 pm} 
 #								  last update: 13/12/96 {1:13:30 am} 
 #	Author:	Vince Darley
 #	E-mail:	<vince@deas.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 #	See	header file	for	further	information
 # ###################################################################
 ##

package require Cpptclextra

proc cpx::contentsList {object} {
	if ![cpptcl isCpptcl $object] {
		return -error "Not a Cpptcl object"
	}
	set contents {}
	foreach c [$object getContents] {
		if { ![catch "$c get"] } {
			lappend contents [list [$c getName] [$c get]]
		}
	}
	return $contents	
}

proc cpx::prettyContentsList {object} {
	set contents {}
	foreach f [contentsList $object] {
		append contents "\"[lindex $f 0]\" [lindex $f 1]\n"
	}
	return $contents
}

proc cpx::displayContents {object} {
	if ![cpptcl isCpptcl $object] {
		return -error "Not a Cpptcl object"
	}
	if [winfo exists .$object] {
		set i 0
		set w .$object.r
		foreach c [$object getContents] {
			if { ![catch "$c get" val] } {
				$w.f$i configure -text $val 
				incr i
			}
		}
		return
	}	
	set w [toplevel .$object]
	frame $w.l	
	frame $w.m -relief groove -borderwidth 2 -width 2
	frame $w.r
	set i 0
	foreach c [$object getContents] {
		if { ![catch "$c get"] } {
			label $w.l.f$i -text [$c getName] -anchor w
			label $w.r.f$i -text [$c get] -anchor w
			pack $w.l.f$i -side bottom -fill x
			pack $w.r.f$i -side bottom -fill x
			incr i
		}
	}
	pack $w.l $w.m $w.r -side left -fill y	
}

proc cpx::entryProc {win item val} {
}

