package require Cpptcl

class cpx::ObjectControl {

    constructor {args} {
    	#eval configure $args
    }

    protected variable EvoxSimPeer
    public variable peer "local"
    
    public method call {args} 
    public method getObjectsFromSimulation { name } 
    public method getObjects {obj} 
    public method barObjectMenu { menuName menuTitle fromObject } 
    public method objectMenu { base fromObject } 
    public method hierarchialObjectMenu { submenu obj }

    proc findFileForType {dir ext args}
    proc bitmapForType {type {obj ""}}
    proc gifForType {type {obj ""}}

    private proc _findFileForType {dir ext type}

}

body cpx::ObjectControl::findFileForType {dir ext args} {
	foreach trytype $args {
		set try [_findFileForType $dir $ext $trytype]
		if {$try != ""} {
			return $try
		}
    }
	return ""
}


body cpx::ObjectControl::_findFileForType {dir ext type} {
	set try [file join $dir [eval join [subst $type] \"\"]${ext}]
	if { [file exists $try] } {
		return $try
	} else {
		foreach o [uplevel \#0 cpptclControl listAncestry $type ] {
			set try [file join $dir [eval join \"$o\" \"\"]${ext}]
			if { [file exists $try] } {
				return $try
			}
		}
	}   
}

body cpx::ObjectControl::bitmapForType {type {obj ""}} {
	global ::cpx::options
	set types {}
	if { $type == "Info Source Bool" && $obj != ""} {
		set types "${type}[uplevel \#0 $obj getValue]"
	}
	lappend types $type
	return @[findFileForType $options(BITMAPDIR) ".xbm" $types]
}


body cpx::ObjectControl::gifForType {type {obj ""}} {
	global ::cpx::options
	set types {}
	if { $type == "Info Source Bool" && $obj != ""} {
		set types "${type}[uplevel \#0 $obj getValue]"
	}
	lappend types $type
	return [findFileForType $options(GIFDIR) ".gif" $types]
}

body cpx::ObjectControl::call {args} {
	switch [lindex $peer 0] {
	  "local" {
	  	eval $args
	  }
	  "remote" {
	  	eval dp_RPC [lindex $peer 1] $args
	  }
	  "interp" {
	  	[lindex $peer 1] eval $args
	  }
	  "default" {
	  	error "Unknown peer option"
	 }
	}
}	

body cpx::ObjectControl::getObjectsFromSimulation {name } {
	cpxStatus "Querying simulation for new object types."
	set peer $EvoxSimPeer($name)
	if { $peer != "local" } {
		foreach obj [call cpptclControl listTypes] {
			getObjects "$obj"
			
		}
	}	
}

body cpx::ObjectControl::getObjects {obj} {
	set com [call cpptclControl commandFor "$obj"]
	set parents [call cpptclControl listParents "$obj" ]
	if { $com == "" } {
		cpptclControl addObjectType $obj $parents
	} else {
		cpptclControl addObjectType -command $com $obj $parents
	}
	
	foreach obj [call cpptclControl listTypes "$obj"] {
		getObjects "$obj"
	}
}

body cpx::ObjectControl::barObjectMenu { menuName menuTitle fromObject } {
	if { ![winfo exists $menuName] } {
		menubutton $menuName -text "$menuTitle"  \
			-menu $menuName.menu
	}
	objectMenu $menuName "$fromObject"
	
	return $menuName

}

body cpx::ObjectControl::objectMenu { base fromObject } {
	if { ![winfo exists $base.menu] } {
		menu $base.menu
	}
	
	# loop through all object types in hierarchial fashion
	# note some will not be creatable, as they will be abstract classes
	
	hierarchialObjectMenu $base.menu $fromObject
	return $base.menu
}

body cpx::ObjectControl::hierarchialObjectMenu { submenu obj } {
	# if I can be created, despite having children, put in an item
	if { [cpptclControl commandFor "$obj"] != "" } {
		if { [catch { $submenu index "create basic '$obj'" } ] } {
			$submenu add command -label "create basic '$obj'" \
				[code $this addObject \{$obj\}]
		}
	}
	# in any case:
	foreach s [cpptclControl listTypes "$obj"] {
		if { [cpptclControl commandFor "$s"] == "" \
			|| [cpptclControl hasDescendants "$s"]} {
			set m ${submenu}.[evoxToTclLower $s]
			if { ![winfo exists ${m}m] } {
				menu ${m}m
			}
			if { [catch { $submenu index "$s" } ] } {
				$submenu  add cascade -label "$s" -menu ${m}m
			}
			hierarchialObjectMenu ${m}m "$s"
		} else {
			if { [catch { $submenu index "$s" } ] } {
				${submenu} add command -label "$s" \
				-command [code $this addObject \{$s\}]
			}
		}
	}
	
}
