
	
itcl::class cpx::TreeItem {
	inherit Widget
	
	constructor {cvs args} {
		set canvas $cvs
		itk_component add label {
			label $itk_interior.label
		} {
			keep -background
			keep -foreground
			keep -cursor
			keep -text
		}
		pack $itk_component(label) -side right
		eval itk_initialize $args
	}
	
	destructor {
		deselect
		$canvas delete $this
	}

	public method select {} {}
	public method deselect {} {}
	private variable canvas ""
}

itcl::class cpx::TIplain {
	inherit cpx::TreeItem
	constructor {type cvs args} {
		eval cpx::TreeItem::constructor $cvs $args
	} {
	}	
	
}

itcl::class cpx::TIbitmap {
	inherit cpx::TreeItem
	
	constructor {type cvs args} {
		eval cpx::TreeItem::constructor $cvs $args
	} {
		set _type $type
		itk_component add pict {
			label $itk_interior.lb1 -bitmap [cpx::ObjectControl::bitmapForType $_type]
		} 
		pack $itk_component(pict) -side left
		eval configure $args
	}
	
	private variable _type ""
}

itcl::class cpx::TIgif {
	inherit cpx::TreeItem
	
	constructor {type cvs args} {
		eval cpx::TreeItem::constructor $cvs $args
	} {
		set _type $type
		itk_component add pict {
			set im [image create photo -file [cpx::ObjectControl::gifForType $_type]]
			label $itk_interior.lb1 -image $im
		} 
		pack $itk_component(pict) -side left
		eval configure $args
	}
	
	private variable _type ""
}

