class TCL_OBJ
	-- simple example class containing a tk_interpreter and
	-- some installed tcl commands, which manipulate the
	-- Current object.

creation
    make
    
creation {CREATE_CMD}
    new

feature
    interpreter : TK_INTERPRETER;

    var1, var2   :STRING;
	-- these are the variables to be shared between Eiffel and tcl.

    set_vars (val1, val2 :STRING) is
	do
	    var1 := clone(val1);
	    var2 := clone(val2);
	    to_tcl;
	end; -- set_vars

    to_tcl is
	-- transfer values of variables var1, var2 to tcl.
	do
	    interpreter.set_var ("var1", var1);
	    interpreter.set_var ("var2", var2);
	end; -- to_tcl

    from_tcl is
	-- get vaules of variables var1, var2 from tcl.
	local
	    tmp : ANY;
	do
	    tmp := interpreter.get_var("var1");
	    var1 := clone(tmp.out);
	    tmp := interpreter.get_var("var2");
	    var2 := clone(tmp.out);
	end; -- from_tcl
	

    init (def1, def2 : STRING) is
	-- set up a newly created object
    	local 
 	    init_file :UNIX_FILE;
	    cmd :TCL_COMMAND;
    	do
            !!interpreter.make("EIF-TCL-TK");
	    !!init_file.make("./tcltest.tcl");
	    if init_file.exists then
		interpreter.eval_file(init_file.name);
	    end;
	    !DEFAULTS_CMD!cmd.make(Current, def1, def2);
	    cmd.install(interpreter, "defaults");
	    !PRINT_CMD!cmd.make(Current);
	    cmd.install(interpreter, "print");
	    !CREATE_CMD!cmd.make(Current);
	    cmd.install(interpreter, "new_win");
	    !CLOSE_CMD!cmd.make(Current);
	    cmd.install(interpreter, "close_win");
	    to_tcl;
 	    interpreter.show(interpreter.non_modal);
	    io.putstring("Done%N");
	end; -- init

    make is
	-- make the first TCL_OBJ
	do
	    !!var1.make(0);
	    !!var2.make(0);
	    init("Amazing...", "Isn't it?");
    	end; -- make

    new (parent : TCL_OBJ) is
	-- create a new TCL_OBJ as sort of clone of current.
	do
	    var1 := clone(parent.var1);
	    var2 := clone(parent.var2);
	    init (var1, var2);
	end;

end -- class TCL_OBJ

    	    
