
#include "../src/evap.h"
#include "proai_pdt_out"

main (argc, argv)
      int argc;
      char *argv[];

/*
                   PROTOTYPE ALLICATION INTERFACE
   evaluate_parameters, pointer version, type-converted values.

*/

{

  evap_Parameter_Value *pvte; /* parameter value table entry */

  evap (&argc, &argv, pdt, NULL, pvt);
  printf("\nProgram name:\n  %s\n", pvt[P_HELP].unconverted_value);

  if (P_NUMBER_OF_PARAMETERS > 1) {
    printf("\nCommand parameters and values:\n");
    pvte = &pvt[1];
    while (pvte->parameter != NULL) {
      switch (pvte->type) {

      case P_TYPE_SWITCH:
        printf("  switch      parameter %s=%d\n", pvte->parameter,
              pvte->value.switch_value);
        break;

      case P_TYPE_STRING:
        printf("  string      parameter %s=\"%s\"\n", pvte->parameter,
              pvte->value.string_value);
        break;

      case P_TYPE_REAL:
        printf("  real        parameter %s=%.15lg\n", pvte->parameter,
              pvte->value.real_value);
        break;

      case P_TYPE_INTEGER:
        printf("  integer     parameter %s=%d\n", pvte->parameter,
              pvte->value.integer_value);
        break;

      case P_TYPE_BOOLEAN:
        printf("  boolean     parameter %s=%d\n", pvte->parameter,
              pvte->value.boolean_value);
        break;

      case P_TYPE_FILE:
        printf("  file        parameter %s=\"%s\"\n", pvte->parameter,
              pvte->value.file_value);
        break;

      case P_TYPE_KEY:
        printf("  key         parameter %s=\"%s\"\n", pvte->parameter,
              pvte->value.key_value);
        break;

      case P_TYPE_APPLICATION:
        printf("  application parameter %s=\"%s\"\n", pvte->parameter,
              pvte->value.application_value);
        break;

      case P_TYPE_NAME:
        printf("  name        parameter %s=\"%s\"\n", pvte->parameter,
              pvte->value.name_value);
        break;

      default:
        printf("Error!  Murphy says 'Plugh'!\n");
        break;
      } /* casend */

      pvte++; /* next parameter value table entry */

    } /* whilend */
  }

  if (argc > 1) {
    printf("\nFile names:\n  ");
      while (*++argv != NULL)
        printf("%s%s",*argv, (*argv != NULL) ? " " : "");
    printf("\n");
  }

} /* end main */
