# bind.tcl --
#
# This demonstration script creates a text widget with bindings set
# up for hypertext-like effects.
#
# @(#) bind.tcl 1.1 95/05/26 15:56:25

set w .bind
catch {destroy $w}
toplevel $w
wm title $w "Text Demonstration - Tag Bindings"
wm iconname $w "bind"
positionWindow $w

frame $w.buttons
pack  $w.buttons -side bottom -expand y -fill x -pady 2m
button $w.buttons.dismiss -text  -command "destroy $w"
button $w.buttons.code -text R[hQ -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

text $w.text -yscrollcommand "$w.scroll set" -setgrid true \
	-width 60 -height 24 -font $font -wrap word
scrollbar $w.scroll -command "$w.text yview"
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

# Set up display styles.

if {[winfo depth $w] > 1} {
    set bold "-background #43ce80 -relief raised -borderwidth 1"
    set normal "-background {} -relief flat"
} else {
    set bold "-foreground white -background black"
    set normal "-foreground {} -background {}"
}

# Add text to widget.

$w.text insert 0.0 {eLXgwidget̕\X^C𐧌䂷̂Ɠ^ÕJjYgāAeLXgTcl̃R}h蓖Ă邱Ƃł܂BɂA}EXL[{[h̃ANVœTcl̃R}hs悤ɂȂ܂BႦ΁ÃLoX̃fvOɂĂ̐ɂ͂̂悤ȃ^OĂ܂B}EX̏ɎĂƐA{^1Ƃ̐̃fn܂܂B

}

$w.text insert end \
{1. LoX widget ɍ邱Ƃ̂łACe̎ޑSĂ
ւTvB} d1
$w.text insert end \n\n
$w.text insert end \
{2. ȒP 2̃vbgBf[^\_𓮂Ƃ
łB} d2
$w.text insert end \n\n
$w.text insert end \
{3. eLXgACẽAJ[ƍsB} d3
$w.text insert end \n\n
$w.text insert end \
{4. CACê߂̖̓̌`̃GfB^B} d4
$w.text insert end \n\n
$w.text insert end \
{5. ^uXgbvύX邽߂̋@\̃[[B} d5
$w.text insert end \n\n
$w.text insert end \
{6. LoXǂăXN[̂ObhB} d6

# Create bindings for tags.

foreach tag {d1 d2 d3 d4 d5 d6} {
    $w.text tag bind $tag <Any-Enter> "$w.text tag configure $tag $bold"
    $w.text tag bind $tag <Any-Leave> "$w.text tag configure $tag $normal"
}
$w.text tag bind d1 <1> {source $tk_library/demos/items.tcl}
$w.text tag bind d2 <1> {source $tk_library/demos/plot.tcl}
$w.text tag bind d3 <1> {source $tk_library/demos/ctext.tcl}
$w.text tag bind d4 <1> {source $tk_library/demos/arrow.tcl}
$w.text tag bind d5 <1> {source $tk_library/demos/ruler.tcl}
$w.text tag bind d6 <1> {source $tk_library/demos/cscroll.tcl}

$w.text mark set insert 0.0
$w.text configure -state disabled
