# form.tcl --
#
# This demonstration script creates a simple form with a bunch
# of entry widgets.
#
# @(#) form.tcl 1.2 95/06/15 13:01:43

set w .form
catch {destroy $w}
toplevel $w
wm title $w "Form Demonstration"
wm iconname $w "form"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left \
	    -text "̃EBhE͊ȒPȃtH[͗pɂȂĂāA܂܂ȃGgɓ͂ł܂B^uŃGg̐ؑւł܂B"
pack $w.msg -side top

frame $w.buttons
pack  $w.buttons -side bottom -expand y -fill x -pady 2m
button $w.buttons.dismiss -text  -command "destroy $w"
button $w.buttons.code -text "R[hQ" -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

foreach i {f1 f2 f3 f4 f5} {
    frame $w.$i -bd 2
    entry $w.$i.entry -relief sunken -width 40
    label $w.$i.label
    pack $w.$i.entry -side right
    pack $w.$i.label -side left
}
$w.f1.label config -text O:
$w.f2.label config -text Z:
$w.f5.label config -text db:
pack $w.msg $w.f1 $w.f2 $w.f3 $w.f4 $w.f5 -side top -fill x
bind $w <Return> "destroy $w"
focus $w.f1.entry
