# label.tcl --
#
# This demonstration script creates a toplevel window containing
# several label widgets.
#
# @(#) label.tcl 1.1 95/05/26 15:56:33

set w .label
catch {destroy $w}
toplevel $w
wm title $w "Label Demonstration"
wm iconname $w "label"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text {
ɂ 5̃x\Ă܂B\
ɂ̓eLXgx 3A\
Eɂ̓rbg}bvxƃeLXgx܂B\
xƂ̂͂܂ʔ̂ł͂܂B\
ȂȂ璭߂ȊOłȂłB}
pack $w.msg -side top

frame $w.buttons
pack  $w.buttons -side bottom -expand y -fill x -pady 2m
button $w.buttons.dismiss -text  -command "destroy $w"
button $w.buttons.code -text "R[hQ" -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

frame $w.left
frame $w.right
pack $w.left $w.right -side left -expand yes -padx 10 -pady 10 -fill both

label $w.left.l1 -text "ŏ̃x"
label $w.left.l2 -text "2 ԖځBƕオ点Ă݂܂" -relief raised
label $w.left.l3 -text "3 ԖځBł܂ " -relief sunken
pack $w.left.l1 $w.left.l2 $w.left.l3 -side top -expand yes -pady 2 -anchor w

label $w.right.bitmap -bitmap @$tk_library/demos/images/face \
	-borderwidth 2 -relief sunken
label $w.right.caption -text "Tcl/Tk L"
pack $w.right.bitmap $w.right.caption -side top
