#
# Dialog box routines
#
#  (mkDialog is from Tk demos, slightly modified by payne@crl.dec.com
#

if {![info exists appdir]} {
	set appdir .
}

#----------------------------------------------------------------------------
#  Make a bar of buttons and pack into parent.  Embed the left button in an
#  additional sunken frame to indicaute that it is the default button, and
#  arrange for that button to be invoked as the default action for clicks 
#  and returns inthe dialog.
#----------------------------------------------------------------------------
proc mkButtonBar {w every blist} {
	set arg [lindex $blist 0]
	frame $w.0 -relief sunken -border 1
	pack append $w $w.0 {left expand padx 20 pady 20}
	button $w.0.button -text [lindex $arg 0] -width 7 -height 2\
		-command "[lindex $arg 1]; $every"
	pack append $w.0 $w.0.button {expand padx 12 pady 12}
	bind $w <Return> "[lindex $arg 1]; $every"
	focus $w

	set i 1
	foreach arg [lrange $blist 1 end] {
	    button $w.$i -text [lindex $arg 0] -width 7 -height 2\
		    -command "[lindex $arg 1]; $every"
	    pack append $w $w.$i {left expand padx 20}
	    set i [expr $i+1]
	}
}

#
#  Make a new dialog toplevel window
#
proc mkDialogWindow {w} {
    catch {destroy $w}
    toplevel $w -class Dialog -bd 0
    wm title $w "Dialog box"
    wm iconname $w "Dialog"
    wm geometry $w +425+300
    grab $w
    focus $w
    return $w
}

# mkDialog w msgArgs list list ...
#
# Create a dialog box with a message and any number of buttons at
# the bottom.
#
# Arguments:
#    w -	Name to use for new top-level window.
#    msgArgs -	List of arguments to use when creating the message of the
#		dialog box (e.g. text, justifcation, etc.)
#    list -	A two-element list that describes one of the buttons that
#		will appear at the bottom of the dialog.  The first element
#		gives the text to be displayed in the button and the second
#		gives the command to be invoked when the button is invoked.

proc mkDialog {w bitmap msgArgs blist} {
    global appdir

    mkDialogWindow $w

    # Create two frames in the main window. The top frame will hold the
    # message and the bottom one will hold the buttons.  Arrange them
    # one above the other, with any extra vertical space split between
    # them.

    frame $w.top -relief raised -border 1
    frame $w.bot -relief raised -border 1
    pack append $w $w.top {top fill expand} $w.bot {top fill expand}
    
    # Create the message widget and arrange for it to be centered in the
    # top frame.
    
    eval message $w.top.msg -justify left -aspect 500\
	    -font -Adobe-times-medium-r-normal--*-180* $msgArgs
    pack append $w.top $w.top.msg {right expand padx 20 pady 20}

    if {[llength $blist] > 0} {
	mkButtonBar $w.bot "destroy $w; update" $blist
    }
}

proc mkInfoDialog {w text args} {
	mkDialog $w warning "-text \"$text\"" $args
}

proc mkErrorDialog {w text args} {
	mkDialog $w error "-text \"$text\"" $args
}
