.\" @(#) tree.n 1.3 30 Sep 1994 (C) SNI AG; MR STO SI 134, MR OI 2
.\"
.\" Copyright 1993 Allan Brighton.
.\" 
.\" Permission to use, copy, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies.  Allan
.\" Brighton make no representations about the suitability of this software
.\" for any purpose.  It is provided "as is" without express or implied
.\" warranty.
.\" 
.so man.macros
.HS tree tkcxx
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tree \- Create and manipulate tree widgets
.SH SYNOPSIS
\fBtree\fI \fIpathName ?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBborderWidth\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBparentDistance\fR
Class:	\fBParentDistance\fR
Command-Line Switch:	\fB\-parentdistance\fR
.fi
.IP
Specifies the desired distance between a tree node and its parent in any of the forms
acceptable to \fBTk_GetPixels\fR. The default value is 30 pixels.
.LP
.nf
Name:	\fBlayout\fR
Class:	\fBLayout\fR
Command-Line Switch:	\fB\-layout\fR or \fB\-orient\fR
.fi
.IP
Specifies the desired layout or orientation of the tree in its canvas and may have the value
\fBhorizontal\fR or \fBvertical\fR.
The default is horizontal.
.BE

.SH DESCRIPTION
.PP
The \fBtree\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a tree widget. 
Note that the tree widget
must be a child of the canvas widget in which it will be displayed.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the tree such as the border width around the tree.
The \fBtree\fR command returns the
path name of the new window.
.PP
\fIThis man page describes the basic Tk tree widget, which is implemented in C++.
There is also an [incr Tcl] class call \fBTree\fI, which is based on this widget.
See \fBitclTree\fI(n) for a description on that class.\fR
.PP
The tree widget only manages the items in its canvas. 
You create the items that make up a node
and the line that connects it to its parent with
the canvas widget command at any position on the canvas.
Once created, the tree widget moves the items around
on the canvas and adjusts the lines to connect the nodes of the tree.
Multiple canvas items can be grouped together to form a single tree node 
by having them share a common, unique tag.

.SH "WIDGET COMMAND"
.PP
The \fBtree\fR command creates a new Tcl command whose
name is the same as the path name of the tree's window.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIPathName\fR is the name of the command, which is the same as
the tree widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for tree widgets:
.TP
\fIpathName \fBaddlink \fIparent child line \fR?\fIoption value option value ...\fR?
Add a node to the tree. Canvas items with the \fIparent\fR, \fIchild\fR and
\fIline\fR tags or ids must already exist. 
They may be created anywhere on the canvas, since
the relative positions of the items within a node will remain unchanged as the node is
moved. 
All the items with the tag or id \fIchild\fR make up the new node. The new node
is inserted as a child of the node named by \fIparent\fR, which must already exist
in the tree. \fIline\fR is the tag or id of a canvas line, which should be created
with length 0. The tree widget will set the relative positions of the items and change
the position and length of the line as needed. 
There is one special invisible root node that is created automatically 
for each tree and has the empty tag "" (or {}).  The root node (or nodes) that are visible
in the tree are the children of this super node and are inserted in the tree with
\fIparent\fR = "".
The following options are supported:
.RS
.TP
\fB\-border \fIwidth\fR Specifies the width of the nodes border in any
of the forms acceptable to \fBTk_GetPixels\fR. This determines the
distance between the individual nodes in the tree. The default is 0.
.TP
\fB\-remove \fItclCode\fR
Specifies tcl code to be evaluated when the node is removed from the tree.
\fItclCode\fR must be a string containing valid tcl commands.
This option is necessary when a node contains a window such as a listbox or button,
so that these will also be properly deleted.  The default action, when a node is to
be removed, is to use the \fIcanvas delete\fR command to delete the canvas items
with the given tag or id.
.RE
.TP
\fIpathName \fBchild\fR \fItagOrId\fR
Return the name of the child of the node named by \fItagOrId\fR.
If the node has no children, an empty string is returned. 
If the node has more than one child, the name of the first child is returned.
The \fIpathName \fBsibling\fR command can be used to get the names of the other
children in sequence.
.TP
\fIpathName \fBconfigure \fR?\fIoption value option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtree\fR
command.
.TP
\fIpathName \fBcget \fR?\fIoption\fR?
Returns the widgets's value for the given option, which may be any of the options
accepted by the \fBtree\fR command.
.TP
\fIpathName \fBdraw\fR This command causes the tree to draw itself in
the canvas.  The tree normally redraws itself automatically when
needed, but this command can be used to force it to redraw itself
immediately before any of the canvas items become visible.
.TP
\fIpathName \fBisleaf\fR \fItagOrId\fR
Return true ("1") if the named node is a leaf (has no children) and
false ("0") otherwise.
.TP
\fIpathName \fBisroot\fR \fItagOrId\fR
Return true ("1") if the named node is a root node 
(i.e.: is a child of invisible root node) and false ("0") otherwise.
Note that it is possible to have multiple (visible) root nodes that are all
internally managed as children of an invisible root node with size 0 and no
connecting lines. The invisible root node can be referenced with an empty
tag "". 
.TP
\fIpathName \fBmovelink \fIchild parent\fR
Move the subtree whose root is the node named by \fIchild\fR
so that it becomes a subtree of the node named by \fIparent\fR. i.e.: the \fIchild\fR
becomes a child of \fIparent\fR. 
This can be used, for example, to add the parent of the root node to a tree: first 
add a second root node, then move the old root to (under) the new root.
.TP
\fIpathName \fBnodeconfigure \fItagOrId \fR?\fIoption value option value ...\fR?
Recalculate the node's (and the tree's) size and position and set node options.  
This command accepts the same options as the \fIpathName \fBaddlink\fR command and should be
used whenever a node has changed size or whenever any of the node's options are to
be changed.
.TP
\fIpathName \fBparent\fR \fItagOrId\fR
Return the name of the parent of the node named by \fItagOrId\fR.
If the node has no parent (i.e.: is a root node), an empty string is returned. 
.TP
\fIpathName \fBancestors\fR \fItagOrId\fR
This command returns a Tcl list of this nodes ancestors, for 
example: {parent grandparent ...}.
.TP
\fIpathName \fBprune\fR \fItagOrId\fR
The subnodes of the node named by \fItagOrId\fR are removed from the tree and
deleted from the canvas. The named node is left in the tree.
.TP
\fIpathName \fBrmlink\fR \fItagOrId\fR
Remove the node named by \fItagOrId\fR and all its subnodes from the tree.
The canvas items corresponding to the removed nodes are also deleted.
.TP
\fIpathName \fBroot\fR \fItagOrId\fR
The node named by \fItagOrId\fR becomes the new root of the tree. Any nodes that
are not subnodes of the named node are deleted.
.TP
\fIpathName \fBsibling\fR \fItagOrId\fR
Return the name of the next sibling of the node named by \fItagOrId\fR.
If the node has no sibling, an empty string is returned. 
.TP
\fIpathName \fBsubnodes\fR \fItagOrId\fR
Return a list containing the names of the subnodes of the node named by \fItagOrId\fR.
Only the child node, if any, and its siblings are in the list.

.SH BINDINGS
.PP
When a new tree is created, it has no default event bindings.
The bindings should be set on the canvas and canvas items.

.SH AUTHOR
.TP 0
Allan Brighton - abrighto@eso.org
.SH KEYWORDS
tree, widget
