// -*-c++-*-
#ifndef _TclDirCmd_h_
#define _TclDirCmd_h_

/*
 * TclDirCmd.h - class declarations for "Dir" tcl command
 *
 * -----------------------------------------------------------------------------
 * Copyright 1994 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  
 * Allan Brighton make no representations about the suitability of this 
 * software for any purpose. It is provided "as is" without express or 
 * implied warranty.
 * -----------------------------------------------------------------------------
 */

#include "config.h"
#include "TclCommand.h"

/* This class declares the methods used to implement the Tcl "Dir"
 * command.  This command should be some what faster than "glob" or
 * "ls" for getting a list of "only files" or "only dirs" in a
 * directory.  In addition, the commands "cd" and "pwd" are added, to
 * make the interface useful for use over a tcp connection (for
 * example for a remote file browser).  
 */

class TclDirCmd : public TclCommand {
private:
    // -- methods --

    DIR* opendir_(const char* dirname);
    int isdir_(const char* dir, const char* name);
    int isfile_(const char* dir, const char* name);

public:

    // call a member function by name
    virtual int call(const char* name, int len, int argc, char* argv[]);

    // -- tcl subcommands --

    int ls_(int argc, char* argv[]);
    int lsfiles_(int argc, char* argv[]);
    int lsdirs_(int argc, char* argv[]);
    int cd_(int argc, char* argv[]);
    int pwd_(int argc, char* argv[]);

    // tcl command routine
    static int dirCmd(ClientData, Tcl_Interp*, int argc, char* argv[]);

    // constructor
    TclDirCmd(Tcl_Interp*, const char* cmdname, const char* instname);
};

#endif /* _TclDirCmd_h_ */
