// -*-c++-*-
#ifndef _TkTreeNode_h_
#define _TkTreeNode_h_

/*
 * TkTreeNode.h - class definitions for drawing tree nodes using Tk
 * 
 * Class TkTreeNode redefines virtual functions from its base class,
 * TreeNode, to allow drawing nodes on a tk canvas.
 * 
 * -----------------------------------------------------------------------------
 * Copyright 1994 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  
 * Allan Brighton make no representations about the suitability of this 
 * software for any purpose. It is provided "as is" without express or 
 * implied warranty.
 * -----------------------------------------------------------------------------
 */

#include <tk.h>
#include <string.h>
#include "config.h"
#include "TreeNode.h"

class TkTree;


/*
 * This class implements the TK specific parts of drawing trees
 * by redefining virtual drawing routines.
 */
class TkTreeNode : public TreeNode {
private:
    TkTree* tree_;	// hook to main tree class
    char* removeCmd_;	// optional tcl code to remove window items
    char* line_; 	// Id of Tk canvas line connecting this node to its parent
    
    // draw a node in the tree 
    virtual void drawNode() const;
    
    // remove a node from the tree 
    virtual void removeNode() const;
    
    // redraw the line to the parent node at the given coords 
    virtual void drawLine(const TreePoint& p1, const TreePoint& p2) const;
    
    // remove the line from the parent 
    virtual void removeLine() const;
    
    // return distance from parent node
    virtual int parentDistance() const;
    
    // called with the bounding box of the tree before drawing
    virtual void setDrawArea(int x1, int y1, int x2, int y2) const;
    
    // tree's orientation 
    virtual int horizontal() const;
    
public:
    
    // construct a node with given tag, pos and size
    TkTreeNode(TkTree*, const char* tag, const char* line, 
        int x=0, int y=0, int w=0, int h=0, int border=0);
    
    // destructor
    virtual ~TkTreeNode();

    void removeCmd(const char* s);
    
};

#endif /* _TkTreeNode_h_ */
