# Canvas.tcl - itcl class based on the Tk canvas widget
# 
# Usage: Canvas $w_.c [options]
# (see below for options)
#
# Copyright (C) 1994 Allan Brighton (abrighto@eso.org)
# "@(#) $Id: CanvasWidget.tcl,v 1.1 1996/05/09 15:56:56 abrighto Exp $"


itk::usual CanvasWidget {}

class util::CanvasWidget {
    inherit FrameWidget

    # create the canvas and scrollbars

    constructor {args} {
	itk_component add canvas {
	    canvas $w_.canvas -scrollregion {0 0 0 0}
	} {
	    keep -width -height -borderwidth -relief
	    usual
	    rename -background -canvasbackground canvasBackground CanvasBackground
	}

	itk_component add vscroll {
	    scrollbar $w_.vscroll \
		-relief sunken \
		-command "$w_.canvas yview"
	}
	itk_component add hscroll {
	    scrollbar $w_.hscroll \
		-orient horiz \
		-relief sunken \
		-command "$itk_component(canvas) xview"
	}
	$itk_component(canvas) config \
		-xscrollcommand "$itk_component(hscroll) set" \
		-yscrollcommand "$itk_component(vscroll) set"
	
	bind $itk_component(canvas) <ButtonPress-2> "$itk_component(canvas) scan mark %x %y"
	bind $itk_component(canvas) <B2-Motion> "$itk_component(canvas) scan dragto %x %y"

	pack $itk_component(hscroll) -side bottom -fill x
	pack $itk_component(vscroll) -side right -fill y
	pack $itk_component(canvas) -fill both -expand 1

	eval itk_initialize $args
    }
}
