# FrameWidget.tcl - itk base class for widgets with their own frame
#
# Copyright (C) 1996 Allan Brighton (abrighto@eso.org)
#
# "@(#) $Id: FrameWidget.tcl,v 1.2 1996/05/23 19:13:32 abrighto Exp $"

class util::FrameWidget {
    inherit itk::Widget

    # Create a frame with the same name as this object

    constructor {args} {
	set w_ $itk_component(hull)
	eval itk_initialize $args

	after idle [code $this init]
    }


    # derived classes can re-define the "init" method to run code after all 
    # options have been evaluated
    
    method init {} {
    }


    # run the given tcl command while displaying the busy cursor
    # in the frame's parent top level window

    public method busy {cmd} {
	global ::errorInfo ::errorCode

	if {[incr busy_count_] == 1} {
	    catch {focus .}
	    blt_busy hold $w_
	    update idletasks
	}

	# save any errors and report them later
	if {[set code [catch [list uplevel $cmd] msg]]} {
	    set info $errorInfo
	} 

	if {[incr busy_count_ -1] == 0} {
	    blt_busy release $w_
	    catch {focus -lastfor $w_}
	}

	if {$code} {
	    uplevel [list error $msg $info $code]
	}
    }

    # set the text of short help message to be displayed whenever
    # the mouse enters the widget w (assumes you are using class
    # ToplevelWidget)

    public method add_short_help {w msg} {
	catch {[winfo command [winfo toplevel $w_]] add_short_help $w $msg}
    } 


    # set the text of the short help message (display now, assumes you 
    # are using class ToplevelWidget)

    public method short_help {msg} {
	catch {[winfo command [winfo toplevel $w_]] short_help $msg}
    } 

    
    # -- options --

 
    # -- class variables --

    # shorter name for $itk_component(hull)
    protected variable w_

    # count used for busy cursor
    private variable busy_count_ {0}
}

