.\" Author: Allan Brighton.
.so man.macros
.HS Tree itk
.BS
.SH NAME
Tree \- An [incr Tk] Tree widget based on the Tk tree widget
.SH SYNOPSIS
\fBTree\fI \fIpathName \fR?\fIoptions\fR?
.ta 4c
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB-borderwidth\fR 
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
\fB\-parentdistance\fR \fIpixels\fB
.fi
.IP
Specifies the desired distance between a tree node and its parent in any of the forms
acceptable to \fBTk_GetPixels\fR. The default value is 30 pixels.
.LP
.nf
\fB\-layout\fR \fIhorizontal|vertical\fB
.fi
.IP
Specifies the desired layout or orientation of the tree in its canvas and may have the value
\fBhorizontal\fR or \fBvertical\fR.
The default is horizontal.
.LP
.nf
\fB\-orient\fR \fIhorizontal|vertical\fB
.fi
.IP
This is an alias for \fB\-layout\fR.
.BE
.SH DESCRIPTION
.PP
The \fBTree\fR command creates a new window with the same name as the
\fIpathName\fR argument and makes it into an Itk Tree widget.
The \fBTree\fR widget is composed of a Tk frame containing a 
canvas window with vertical and horizontal scrollbars and the basic
Tk tree widget, as implemented in C++.
The \fBTree\fR command returns its \fIpathName\fR argument.

.SH "WIDGET COMMAND"
.PP
The \fBTree\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget. It has the following general form:
.DS C
\fIpathName subcmd \fR?\fIargs\fR?
.DE
.LP
\fISubcmd\fR and the \fIargs\fR
determine the exact behavior of the command.  
The following subcommands are available for Itk Tree widgets:
.TP
\fIpathName \fBconfigure\fR \fIoption\fR \fIvalue ?option value ...\fR?
Modify or query the configuration options of the widget.
\fIOption\fR may have any of the values accepted by the \fBTree\fR
command.
.TP
\fIpathName \fBadd_node\fR \fIparent node\fR ?\fB-label \fIlabel\fR? ?\fB-bitmap \fIbitmap\fR? 
Adds the given node to the tree under the given parent node (if not already there).
If \fI-label\fR is specified, the node will display the text of the label.
If \fI-bitmap\fR is specified, the node will display the given bitmap (the bitmap should
be specified in the standard way, i.e.: \fI@/path/bitmap.xbm\fR). 
If both \fB-label\fR and \fB-bitmap\fR are specified, the node will display both.
.TP
\fIpathName \fBget_selected\fR
Returns the tag of the selected node or the node that was last selected.
.TP
\fIpathName \fBget_current\fR
Returns the tag of the node under the mouse pointer, or empty if there is none.
.TP
\fIpathName \fBselect_node\fR
Selects the current node's label (the one under the mouse cursor).
.TP
\fIpathName \fBdeselect_node\fR
Clears the selection in the canvas, so that no tree nodes are selected.
.TP
\fIpathName \fBselect_bitmap\fR
Highlights the current node's bitmap.
.TP
\fIpathName \fBdeselect_bitmap\fR
Stops highlighting the selected node's bitmap.
.TP
\fIpathName \fBcenter\fR
Centers the tree in the canvas.
.TP
\fIpathName \fBtoggle_layout\fR
Toggle the layout of the tree between vertical and horizontal.
.TP
\fIpathName \fItree-subcommand ...\fR
Any of the commands described in \fBtree\fR(n) are also available here and
are simply forwarded to the tree widget.
.SH "DEFAULT BINDINGS"
.PP
The Tree widget automatically creates bindings that give it
the following default behavior:
.IP [1]
When button 1 is pressed over a tree node's label, the label is selected.
When button 1 is pressed over a tree node's bitmap, the bitmap is selected.
.IP [2]
The view in the Tree can be adjusted by dragging with mouse button 2.
.PP
The behavior of Trees can be changed by defining new bindings for
the canvas items composing the Tree. 
For example, if your Tree widget is called $tree, you can
access a node's label with the canvas tag \fInode\fB:text\fR and its bitmap
with the tag \fInode\fB:bitmap\fR, where \fInode\fR is the name you gave the tree
node when you added it with \fBadd_node\fR. Tree lines have tags that include the node and its 
parent: \fIparent\fB:\fInode\fB:line\fR.
See the Tree sources for more detailed information.

.SH AUTHOR
.TP 0
Allan Brighton - abrighto@eso.org
.SH KEYWORDS
Tree, widget
