/* 
 * tkAppInit.c --
 *
 *	Provides a default version of the Tcl_AppInit procedure for
 *	use in wish and similar Tk-based applications.
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef lint
static char sccsid[] = "@(#) tkAppInit.c 1.15 95/06/28 13:14:28";
#endif /* not lint */

#include <stdlib.h>

/* declare command procedures here */
extern "C" {
#include "tk.h"

#ifdef USE_BLT
extern int Blt_Init(Tcl_Interp *interp);
#endif 

#ifdef USE_ITCL
extern int Itcl_Init(Tcl_Interp *interp);
#endif

#ifdef USE_ITK
extern int Itk_Init(Tcl_Interp *interp);
#endif

#ifdef USE_TCLX
extern int Tclxcmd_Init(Tcl_Interp *interp);
#endif

extern int Tree_Init(Tcl_Interp *interp);

extern int Dir_Init(Tcl_Interp *interp); /* only needed for the demo */
}

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

extern "C" {
    extern int matherr();
}
static int (*dummyMathPtr)() = matherr;


/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tk_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
main(int argc,			/* Number of command-line arguments. */
    char **argv)		/* Values of command-line arguments. */
{
    Tk_Main(argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(Tcl_Interp *interp)		/* Interpreter for application. */
{
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    /* --------------------------------------------------
     * Changes for Tree Widget:
     *
     * Note: the C++ tree widget does not need Itcl, 
     * but some demos (and the Itk Tree widget class) depend on them.
     */
#ifdef USE_ITCL
    if (Itcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif

#ifdef USE_ITK
    if (Itk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    // there seem to be problems loading Iwidgets in Tcl7.5/Tk4.1 unless the
    // pkgIndex.tcl file is in the same dir as the tree_wish binary...
    if (Tcl_PkgRequire(interp, "Iwidgets", NULL, 0) == NULL) {
	printf("warning: could not load Iwidgets package: %s\n(%s)\n", 
	       interp->result, 
	       "try copying pkgIndex.tcl to directory containing tree_wish");
    }
#endif

#ifdef USE_BLT
    if (Blt_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif

#ifdef USE_TCLX
    /* add tclX commands, but not the whole tclX env */
    if (Tclxcmd_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif

    /* initialize the tree command */
    if (Tree_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    /* initialize the Dir command */
    if (Dir_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    /* ------------------------------------------------------------*/
    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    Tcl_SetVar(interp, "tcl_rcFileName", "~/.itkwishrc", TCL_GLOBAL_ONLY);
    return TCL_OK;
}
