#----------------------------------------------------------------------
# Method resolution and caching
#

proc prInherits {} {
	global _obTcl_Classes
	foreach i [array names _obTcl_Classes]\
		{puts "$i inherits from: [$i inherit]"}
}

proc inherit { class args } {
	global _obTcl_Inherits

	if { "$args" == "" } {
		return [set _obTcl_Inherits($class)]
	}
	if { "$class" != "Base" && [lsearch $args "Base"] == -1 } {
		set args [concat $args "Base"]
	}
	if { [info exists _obTcl_Inherits($class)] == 1 } {
		#
		# This class is not new, invalidate caches
		#
		InvalidateCaches 0 $class [classInfoCached ${class}]
	} else {
		set _obTcl_Inherits($class) {}
	}
	set _obTcl_Inherits($class) $args
}

proc InvalidateCaches { level class methods } {
	global _obTcl_CacheStop

	dbputs "InvalidateCaches $level $class $methods"
	foreach i $methods {
		if {"$i" == "unknown" } { set i "*" }
		set _obTcl_CacheStop($i) 1
	}
	if [array exists _obTcl_CacheStop] { DoInvalidate }
}

# There is a catch on rename and unset since current build of tmp
# does not guarantee that each element is unique.

proc DoInvalidate {} {
	global _obTcl_CacheStop _obTcl_Cached
	if ![array exists _obTcl_Cached] {
		unset _obTcl_CacheStop
		return
	}
	if [info exists _obTcl_CacheStop(*)] {
		set stoplist "*"
	} else {
		set stoplist [array names _obTcl_CacheStop]
	}
	dbputs "DoInvalidate: Invalidating $stoplist"
	foreach i $stoplist {
		set tmp [array names _obTcl_Cached *::$i]
		eval lappend tmp [array names _obTcl_Cached *::${i}_next]
		foreach k $tmp {
			catch {
				dbputs "unset _obTcl_Cached($k)"
				rename $k {}
				unset _obTcl_Cached($k)
			}
		}
	}
	if {[array size _obTcl_Cached] == 0} {
		unset _obTcl_Cached
	}
	unset _obTcl_CacheStop
}

if { [info procs _oo_unknown] == "" } {
	rename unknown _oo_unknown
}

proc resolve { class func } {
	return [GetFunc 0 $class $func]
}

#----------------------------------------------------------------------
#
# `unknown' and `next' both create cache methods.
#
#----------------------------------------------------------------------
#
# unknown -
#	A missing function was found.  See it it can be resolved
#	from inheritance.
#
#	If function name does not follow the *::* pattern, call the normal
#	unknown handler.
#
#	Umethod is for use by the "unknown" method.  If the method is named
#	`unknown' it will have $method set to $Umethod (the invokers method
#	name).
#

setIfNew unknBarred() ""

proc unknown args {
	global unknBarred
	# Resolve inherited function calls
	#
	set name [lindex $args 0]
	if { [string match "*::*" $name] == 1 } {
		set tmp [split $name :]	
		set class [lindex $tmp 0]
		set func [join [lrange $tmp 2 end] :]

		set flist [GetFunc 0 $class $func]
		if { "$flist" == "" } {
			if [info exists unknBarred($name)] { return -code error }
			set flist [GetFunc 0 $class "unknown"]
		}
		if { "$flist" != "" } {
			# getSelf inlined!
			proc $name args "\
				upvar 1 self self iclass iclass Umethod method
				set Umethod $func
				eval [lindex $flist 0] \$args"
		} else {
			proc $name args "
				return -code error\
				-errorinfo \"Undefined method '$func' invoked\" \
					\"Undefined method '$func' invoked\"
			"
		}
		global _obTcl_Cached
		set _obTcl_Cached(${class}::$func) $class

		# Code below borrowed from init.tcl (tcl7.4)
		#
		global errorCode errorInfo
		set code [catch {uplevel $args} msg]
	    	if {$code ==  1} {
			#
			# Strip the last five lines off the error stack (they're
			# from the "uplevel" command).
			#
			set new [split $errorInfo \n]
			set new [join [lrange $new 0 [expr [llength $new] - 6]] \n]
			return -code error -errorcode $errorCode \
				-errorinfo $new $msg
	    	} else {
			return -code $code $msg
	    	}
	} else {
		eval _oo_unknown $args
	}
}

setIfNew _obTcl_Cnt 0

# 6/11/95 Added _obTcl_nextRet to allow propagation of return-values
#	from `next' calls.  I.e doing `return [next $args]' will
#	be meaningful.  It is only in simple cases that the return
#	value is shure to make sense.  With multiple inheritance
#	it may be impossible to rely on!
#
#	NOTE: This support is experimental and likely to be removed!!!

# Improved for lower overhead with big args-lists
#
proc chkCall { cmd var } {
	global _obTcl_Trace _obTcl_Cnt _obTcl_nextRet
	if [info exists _obTcl_Trace($cmd)] { return $_obTcl_nextRet }

	set _obTcl_Trace($cmd) 1
	catch {uplevel 1 "uplevel 1 \"$cmd \[set $var\]\""} _obTcl_nextRet
	return $_obTcl_nextRet
}

# NextElse is really just a part of proc `next' below.
#
proc NextElse {} {
	uplevel 1 {
		set all [GetNextFunc $class $method]

		foreach i $all {
			# Note: args is the literal _name_ of var to use, hence
			#	no $-sign!
			append tmp "chkCall $i args\n"
		}

		if [info exists tmp] {
			# getSelf inlined!
			# upvar 1 self self iclass iclass Umethod method
			proc $class::${method}_next args "
				$tmp
			"
		} else {
			proc $class::${method}_next args "
				return
			"
		}
		set _obTcl_Cached(${class}::${method}_next) $class

		incr _obTcl_Cnt 1
		set ret [catch {uplevel 1 {${class}::${method}_next} $args} val]
		incr _obTcl_Cnt -1
	}
}

# next -
# Invoke next shadowed method.  Protect against multiple invokation.
# Multiple invokation would occur when several inherited classes inherit
# a common superclass.
#
# Note: I use `info exists' on _obTcl_Cached, rater than `info procs' on
# the corresponding procedure, since checking for a variable seems to be
# about three times faster (Tcl7.4).
#
proc next args {
	global _obTcl_Cnt _obTcl_Cached _obTcl_nextRet
	# getSelf inlined and modified
	upvar 1 self self method method class class iclass iclass

	if { $_obTcl_Cnt == 0 } {
		set _obTcl_nextRet ""
	}
	if [info exists _obTcl_Cached(${class}::${method}_next)] {
		incr _obTcl_Cnt 1
		set ret [catch {uplevel 1 {${class}::${method}_next} $args} val]
		incr _obTcl_Cnt -1
	} else {
		NextElse
	}
	if { $_obTcl_Cnt == 0 } {
		global _obTcl_Trace
		catch {unset _obTcl_Trace}
	}
	if { $ret != 0 } {
		return -code error \
		  -errorinfo "$self: $val" "$self: $val"
	} else {
		return $val
	}
}

# GetNextFunc -
# Get a method by searching inherited classes, skipping the local
# class.
#
proc GetNextFunc { class func } {
	global _obTcl_Inherits

	set all ""
	foreach i [set _obTcl_Inherits($class)] {
		foreach k [GetFunc 0 $i $func] {
			lappendUniq all $k
		}
	}
	return $all
}

# GetFunc -
# Locate a method by searching the inheritance tree.
# Cyclic inheritance is discovered and reported.  A list of all
# found methods is returned, with the closest first in the list.
# Cache-methods are skipped, and will hence not figure in the list.
#
proc GetFunc { depth class func } {
	global _obTcl_Inherits _obTcl_Cached _obTcl_NoClasses

	if { "$depth" > "$_obTcl_NoClasses" } {
		GetFuncErr $depth $class $func
		return ""
	}
	incr depth
	set all ""
	if { [info procs $class::$func] != "" &&
	     ![info exists _obTcl_Cached(${class}::$func)] } {
		return "$class::$func"
	}
	foreach i [set _obTcl_Inherits($class)] {
		set ret [GetFunc $depth $i $func]
		if { $ret != "" } {
			foreach i $ret {
				lappendUniq all $i
			}
		}
	}
	return $all
}

proc GetFuncErr { depth class func } { 
	puts stderr "GetFunc: depth=$depth, circular dependency!?"
	puts stderr "         class=$class func=$func"
}

