#ifndef CDL_RTN_H
#define CDL_RTN_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: CdlRtn.H,v 1.6 1995/05/09 16:14:12 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : CdlRtn.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for CdlRtn class and subclasses. CdlRtn's model
 *               the return types of CdlMethod's.
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// System Inccludes
#include <fstream.h>

// Local Includes
#include "CdlItem.H"

#define CDL_RTN_DEC(a)      \
a (int e = 0);              \
char *giveCommand (void);   \
CdlRtn *instantiate (void); \
static a exemplar;

#define CDL_RTN_DEF(a,b) \
a a :: exemplar(1); \
a :: a (int e) : CdlRtn(e) {} \
char * a :: giveCommand (void) { \
   return #b; \
} \
CdlRtn *a :: instantiate (void) \
{ \
   return new a; \
}

class CdlRtn
{
public:

   CdlRtn (int exemplar = 0);
   virtual ~CdlRtn ();
   virtual char *giveCommand (void) = 0;
   virtual CdlRtn *instantiate (void) = 0;

   virtual int setArgs (int argc, char *argv[]);
   virtual void genPrototype (ofstream &) = 0;
   virtual void declareLocal (ofstream &, CdlIndent) = 0;
   virtual void localName (ofstream &) = 0;
   virtual void postProcess (ofstream &, CdlIndent) = 0;
   virtual void returnFromTclInterp (char *interpName, ofstream &of,
                                     CdlIndent) = 0;
   static CdlRtn *exemplarHead;
   static CdlRtn *exemplarTail;
   CdlRtn *nextExemplar;
};

class CdlIntRtn : public CdlRtn
{
public:
   CDL_RTN_DEC(CdlIntRtn)
   ~CdlIntRtn ();
   void genPrototype (ofstream &);
   void declareLocal (ofstream &, CdlIndent);
   void localName (ofstream &);
   void postProcess (ofstream &, CdlIndent);
   void returnFromTclInterp (char *interpName, ofstream &of, CdlIndent);
};

class CdlFloatRtn : public CdlRtn
{
public:
   CDL_RTN_DEC(CdlFloatRtn)
   ~CdlFloatRtn ();
   void genPrototype (ofstream &);
   void declareLocal (ofstream &, CdlIndent);
   void localName (ofstream &);
   void postProcess (ofstream &, CdlIndent);
   void returnFromTclInterp (char *interpName, ofstream &of, CdlIndent);
};

class CdlDoubleRtn : public CdlRtn
{
public:
   CDL_RTN_DEC(CdlDoubleRtn)
   ~CdlDoubleRtn ();
   void genPrototype (ofstream &);
   void declareLocal (ofstream &, CdlIndent);
   void localName (ofstream &);
   void postProcess (ofstream &, CdlIndent);
   void returnFromTclInterp (char *interpName, ofstream &of, CdlIndent);
};

class CdlStrRtn : public CdlRtn
{
public:
   CDL_RTN_DEC(CdlStrRtn)
   ~CdlStrRtn ();
   void genPrototype (ofstream &);
   void declareLocal (ofstream &, CdlIndent);
   void localName (ofstream &);
   void postProcess (ofstream &, CdlIndent);
   void returnFromTclInterp (char *interpName, ofstream &of, CdlIndent);
};

class CdlObptrRtn : public CdlRtn
{
public:
   CDL_RTN_DEC(CdlObptrRtn)
   int setArgs (int, char *[]);
   ~CdlObptrRtn ();
   void genPrototype (ofstream &);
   void declareLocal (ofstream &, CdlIndent);
   void localName (ofstream &);
   void postProcess (ofstream &, CdlIndent);
   void returnFromTclInterp (char *interpName, ofstream &of, CdlIndent);
private:
   char *className;
};

class CdlObrefRtn : public CdlRtn
{
public:
   CDL_RTN_DEC(CdlObrefRtn)
   int setArgs (int, char *[]);
   ~CdlObrefRtn ();
   void genPrototype (ofstream &);
   void declareLocal (ofstream &, CdlIndent);
   void localName (ofstream &);
   void postProcess (ofstream &, CdlIndent);
   void returnFromTclInterp (char *interpName, ofstream &of, CdlIndent);
private:
   char *className;
   int shouldNew;
};

#endif // CDL_RTN_H
