#ifndef OTCL_CLASS_H
#define OTCL_CLASS_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclClass.H,v 1.6 1995/05/09 16:14:26 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclClass.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for OtclClass class that modells classes of
 *               objects in Object Tcl.
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// Tcl Includes
#include <tcl.h>

// Local Includes
#include "Otcl.H"

// Public Defines
#define MAX_SUPERCLASSES 3
#define OTCL_CLASS_VARIABLE_NAME "_otcl_class_"

// Command Name Defines
#define INSTANCE_METHOD_INTERFACE_CMD      "method"
#define CLASS_METHOD_INTERFACE_CMD         "classMethod"
#define CONSTRUCTOR_INTERFACE_CMD          "constructor"
#define INSTANCE_METHOD_IMPLEMENTATION_CMD "method"
#define CLASS_METHOD_IMPLEMENTATION_CMD    "classMethod"
#define INSTANCE_ATTRIBUTE_CMD             "attribute"
#define CLASS_ATTRIBUTE_CMD                "classAttribute"
#define CONSTRUCTOR_IMPLEMENTATION_CMD     "constructor"
#define DESTRUCTOR_IMPLEMENTATION_CMD      "destructor"

// Forward Class Declaration
class OtclConstructorMethod;
class OtclDestructorMethod;
class OtclInstanceMethod;
class OtclObject;
class OtclPart;
class OtclObjMgr;

// Class    : OtclClass
// Synopsis : An abstract class to hold Otcl class declarations
class OtclClass
{
public:   // Public Constructor & Destructor

   OtclClass (char *name);

   virtual ~OtclClass ();

public:   // Public Instance Methods

   virtual int shouldDelete (void) = 0;

   virtual int isComplete (void) = 0;

   char *giveName (void);

   virtual OtclPart *instantiatePart (Tcl_Interp *, int *returnCode,
                                      int argc, char *argv[], OtclObject *,
                                      OtclPart **partPtr) = 0;

   int instantiate (Tcl_Interp *, int, char *[], OtclObjMgr *);

   virtual int classMethod (Tcl_Interp *, int argc, char *argv[]) = 0;

protected:  // Protected Instance Attributes

   // The class name
   char *name;
};

class OtclClassOtcl : public OtclClass
{
public:   // Prublic Constructor & Destructor

   OtclClassOtcl (char *name, Otcl *parent);

   virtual ~OtclClassOtcl ();

public:   // Public Instance Methods

   int classMethod (Tcl_Interp *, int, char *[]);

   int parseInterface (Tcl_Interp *interp, int argc, char *argv[]);

   int parseImplementation (Tcl_Interp *interp, int argc, char *argv[]);

   int giveIndexOfSuperclass (char *name);

   OtclClass *giveSuperclass (int i);

   int shouldDelete (void);

   OtclPart *instantiatePart (Tcl_Interp *interp, int *returnCode,
                              int argc, char *argv[], OtclObject *,
                              OtclPart **partPtr);

   void instantiateInstanceAttributes(Tcl_HashTable *, Tcl_Interp *);

   // Sets up a new call frame in the interp and sets up
   // the class attributes
   void createClassScope (Tcl_Interp *);
   void destroyClassScope (Tcl_Interp *);

   OtclConstructorMethod *giveConstructorMethod (void);
   OtclDestructorMethod *giveDestructorMethod (void);
   OtclInstanceMethod *giveInstanceMethod (char *name);

   int isComplete (void);

public:   // Public Class Methods

   static int instanceMethodInterfaceCmd (ClientData, Tcl_Interp *,
                                          int argc, char *argv[]);
 
   static int classMethodInterfaceCmd (ClientData, Tcl_Interp *,
                                       int argc, char *argv[]);

   static int constructorInterfaceCmd (ClientData, Tcl_Interp *,
                                       int argc, char *argv[]);

   static int instanceMethodImplementationCmd (ClientData, Tcl_Interp *,
                                               int argc, char *argv[]);

   static int classMethodImplementationCmd (ClientData, Tcl_Interp *,
                                            int argc, char *argv[]);

   static int constructorImplementationCmd (ClientData, Tcl_Interp *,
                                            int argc, char *argv[]);

   static int destructorImplementationCmd (ClientData, Tcl_Interp *,
                                           int argc, char *argv[]);

   static int instanceAttributeCmd (ClientData, Tcl_Interp *,
                                    int argc, char *argv[]);

   static int classAttributeCmd (ClientData, Tcl_Interp *,
                                 int argc, char *argv[]);

   static int classCmd (ClientData, Tcl_Interp *,
                        int argc, char *argv[]);

private:  // Private Instance Methods

   int validMethodName (char *);

   int instanceMethodInterface (Tcl_Interp *, int argc, char *argv[]);

   int classMethodInterface (Tcl_Interp *, int argc, char *argv[]);

   int constructorInterface (Tcl_Interp *, int argc, char *argv[]);

   void placeInterfaceCommandsInScope (Tcl_Interp *);

   void removeInterfaceCommandsFromScope (Tcl_Interp *);

   int parseIsAList (Tcl_Interp *, char *classList);

   void placeImplementationCommandsInScope (Tcl_Interp *);

   void removeImplementationCommandsFromScope (Tcl_Interp *);

   int instanceMethodImplementation (Tcl_Interp *, int argc, char *argv[]);

   int classMethodImplementation (Tcl_Interp *, int argc, char *argv[]);

   int constructorImplementation (Tcl_Interp *, int argc, char *argv[]);

   int destructorImplementation (Tcl_Interp *, int argc, char *argv[]);

   int instanceAttribute (Tcl_Interp *, int argc, char *argv[]);

   int classAttribute (Tcl_Interp *, int argc, char *argv[]); 

   void addClassCommand (Tcl_Interp *);

private:  // Private Instance Methods

   int checkClassCompleteness (Tcl_Interp *);

private:  // Private Instance Attributes

   // Pointer to OtclClass for each superclass.
   OtclClass *superclass[MAX_SUPERCLASSES];
   int noOfSuperclasses;

   // Hash table of OtclInstanceMethods objects (private & public)
   Tcl_HashTable instanceMethods;
   Tcl_HashTable classMethods;

   OtclConstructorMethod *otclConstructorMethod;

   OtclDestructorMethod *otclDestructorMethod;

   // Hash table of OtclAttribute objects
   Tcl_HashTable classAttributes;

   // Hash table of OtclAttributeTemplate objects
   Tcl_HashTable instanceAttributeTemplates;

   Otcl *otcl;

   // OTCL_TRUE if the clas is fully described, false otherwise.
   int complete;

   // Records the old commands from the interp during the processing
   // of an interface or implementation body script
   static Tcl_HashTable commandTable;
};

class OtclClassCpp : public OtclClass
{
public:   // Public Constructors & Destructors

   OtclClassCpp (char *name);

   virtual ~OtclClassCpp ();

public:   // Public Instance Methods

   int shouldDelete (void);

   OtclPart *instantiatePart (Tcl_Interp *interp, int *returnCode,
                              int argc, char *argv[], OtclObject *,
                              OtclPart **partPtr);

   int isComplete (void);

   int classMethod (Tcl_Interp *, int, char *[]) = 0;

public:  // Public Class Methods

   static void registerWithOtcl (Otcl *);

private:  // Private Class Attributes

   // Maintains a list of all instances of OtclClassCpp
   static OtclClassCpp *head;
   static OtclClassCpp *tail;

private:  // Private Instance Attributes

   // Points to next OtclClassCpp object on list maintained
   // by head and tail class attributes.
   OtclClassCpp *next;
};

// Inline Code 
inline char *OtclClass::giveName (void)
{
   return name;
}

#endif // OTCL_CLASS_H
