#ifndef OTCL_OSERVER_H
#define OTCL_OSERVER_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclOserver.H,v 1.3 1995/07/24 09:42:42 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclOserver.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for the Object Tcl - DP extensions
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// System Includes
#include <sys/types.h>
#include <tcl.h>

#include "OtclObject.H"

// Message Type Identifiers
#define INSTANCE_METHOD_RQST 'i'
#define CLASS_METHOD_RQST 'c'
#define DELETE_OBJECT_RQST 'd'
#define NEW_OBJECT_RQST 'n'
#define RESPONSE_MSG 'r'
#define MIN_TCP_IP_PORT 1024
#define MAX_TCP_IP_PORT 32767

// Forward delcaration
struct fd_set;

class OtclChannel
{
public:
   OtclChannel (char *address, Tcl_Interp *, int &result);
   OtclChannel (int fd);
   ~OtclChannel ();

   int streamOut (char);
   int streamOut (long);
   int streamOutNullTerminated (char *);

   int streamIn (char &);
   int streamIn (long &);
   int streamInNullTerminated (char *&);

   int operator == (int fd);
   int getFd (void);

private:
   int sendFull (char *, int);
   int recvFull (char *, int);
   int skt;
};

class OtclResponse;
class OtclRequest;

class OtclOserver
{
public:   // Public Static Attributes

   static void (*addReadFd) (int);
   static void (*rmvReadFd) (int);

public:   // Public Static Methods

   static int initialiseCmd (Tcl_Interp *, int argc, char *argv[]);
   static int processCmd (Tcl_Interp *, int argc, char *argv[]);
   static int oserverCmd (Tcl_Interp *, int argc, char *argv[]);
   static int getAddressCmd (Tcl_Interp *, int argc, char *argv[]);

   static void readableFd (int);

   // Used to initialise the "currentThread" static attribute at
   // start up.
   static char *createOurThreadId (void);

   static OtclResponse *sendRequest (Tcl_Interp *, char *address, OtclRequest*);

private:  // Private static methods

   static void processRequest (int fd, Tcl_Interp *);
   static void cleanupIncommingChannel (int fd);
   static void processConnectionRequest (void);

private:  // Private Attribute

   // The file descriptor set for all of the incomming connections
   // including the listening channel (if this is a server)
   static fd_set *incommingFdSet;

   // A subset of the above set that contains all of the fd's that do not
   // have a request pending for a different thread of execution
   static fd_set *incommingFdSubset;

   // An array of OtclChannel's. OtclChannel object stored against their
   // array fd index.
   static OtclChannel **incommingChannel;

   // Array of strings of thread identifiers.
   static char **incommingThread;

   static OtclChannel *listener;
   static char *address;

   static char *currentThread;

   static Tcl_HashTable *outgoingChannel;
};

class OtclRequest
{
public:
   OtclRequest ();
   virtual ~OtclRequest ();

   virtual int streamIn (OtclChannel *) = 0;
   virtual int streamOut (OtclChannel *) = 0;
   virtual int perform (Tcl_Interp *interp) = 0;
};

class OtclInstanceMethodRqst : public OtclRequest
{
public:

   OtclInstanceMethodRqst ();
   OtclInstanceMethodRqst (char *symRef, char *method, long argc, char *argv[]);
   ~OtclInstanceMethodRqst ();

   int streamIn (OtclChannel *);
   int streamOut (OtclChannel *);

   int perform (Tcl_Interp *interp);

private:

   void clear (void);

   char *symRef;
   char *method;
   long argc;
   char **argv;
};

class OtclDeleteObjectRqst : public OtclRequest
{
public:
   OtclDeleteObjectRqst ();
   OtclDeleteObjectRqst (char *symRef);
   ~OtclDeleteObjectRqst ();

   int streamIn (OtclChannel *);
   int streamOut (OtclChannel *);

   int perform (Tcl_Interp *interp);

private:

   char *symRef;

};

class OtclNewObjectRqst : public OtclRequest
{
public:
   OtclNewObjectRqst ();
   OtclNewObjectRqst (char *className, long argc, char *argv[]);
   ~OtclNewObjectRqst ();

   int streamIn (OtclChannel *);
   int streamOut (OtclChannel *);

   int perform (Tcl_Interp *interp);

private:

   char *className;
   long argc;
   char **argv;

};

class OtclClassMethodRqst : public OtclRequest
{
public:
   OtclClassMethodRqst ();
   OtclClassMethodRqst (char *name, char *method, long argc, char *argv[]);
   ~OtclClassMethodRqst ();

   int streamIn (OtclChannel *);
   int streamOut (OtclChannel *);

   int perform (Tcl_Interp *interp);

private:

   void clear (void);

   char *name;
   char *method;
   long argc;
   char **argv;
};

class OtclResponse
{
public:
   OtclResponse ();
   OtclResponse(int returnValue, Tcl_Interp *interp);
   OtclResponse(int returnValue, char *result);
   ~OtclResponse ();

   int streamIn (OtclChannel *);
   int streamOut (OtclChannel *);

   void setTclInterp (Tcl_Interp *);
   int getReturnValue (void);

private:

   void clear (void);

   long returnValue;
   char *result;
};

class OtclRemoteObject : public OtclObject
{
public:
   OtclRemoteObject (char *symRef, int &result, Tcl_Interp *interp);
   ~OtclRemoteObject ();

   int executeMethod (Tcl_Interp *interp, char *method, int argc, char *argv[]);
   int discard (Tcl_Interp *, int fromCpp);

   // A static version of the above method for the deletion
   // or a remote object that hasn't been used locally and therefore
   // doesn't have a proxy object.
   static int discard (Tcl_Interp *, char *symRef);

private:
   char *remoteSymRef;
   char *address;
};

class OtclRemoteClass
{
public:
   OtclRemoteClass (Tcl_Interp *interp, char *name, char *address);
   ~OtclRemoteClass ();
   int instantiate (Tcl_Interp *, int argc, char *argv[]);
   static int classCmd (ClientData, Tcl_Interp *, int argc, char *argv[]);
   int classMethod (Tcl_Interp *, int argc, char *argv[]);
   void setAddress (char *address, char *realName);
private:
   char *name;
   char *address;
};

#endif
