/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclPart.C,v 1.9 1995/05/09 16:14:44 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclPart.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Contains the implementation for OtclPart an abstract class,
 *               OtclPartOtcl responsible for modelling the parts of an object
 *               that relate to classes in the inheritance hierarchy of an
 *               OtclClass, and OtclPartCpp an abstract class that is subclassed
 *               in C++ code generated by the CDL processor.
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// System Includes
#include <iostream.h>

// Tcl Includes
#include <tclInt.h>

// Local Includes
#include "Otcl.H"
#include "OtclPart.H"
#include "OtclObject.H"
#include "OtclMethod.H"
#include "OtclAttribute.H"

OtclPart::OtclPart (OtclObject *o)
{
   if (o == NULL)
   {
     if ((owner = Otcl::createObjectWrapper(this)) == NULL)
     {
        // report some kind of error and do something?
     }
   }
   else
   {
      owner = o;
   }
}

OtclPart::~OtclPart ()
{
}

OtclObject *OtclPart::giveOwner (void)
{
   return owner;
}

OtclPartOtcl::OtclPartOtcl (Tcl_Interp *interp, int *result, int argc,
                            char *argv[], OtclClassOtcl *c, OtclObject *o,
                            OtclPart **partPtr) :
   OtclPart(o)
{
   otclc = c;
   *partPtr = this;

   Tcl_InitHashTable(&attributes,TCL_STRING_KEYS);
   otclc->instantiateInstanceAttributes(&attributes,interp);
   
   otclc->createClassScope(interp);
   owner->addObjectScope(interp);
   addPartScope(interp);

   OtclConstructorMethod *constructor = otclc->giveConstructorMethod();
   if (constructor != NULL)
   {
      *result = constructor->execute(interp,argc,argv,this);
      if (*result != TCL_OK)
      {
         removePartScope(interp);
         owner->removeObjectScope(interp);
         otclc->destroyClassScope(interp);
         return;
      }
   }
   else
   {
      // Invoke the parent constructors ourself. 
      for (int s = 0; s < MAX_SUPERCLASSES; s++)
      {
         if (constructParent(s,interp,"") != TCL_OK)
         {
            (*result) = TCL_ERROR;
            removePartScope(interp);
            owner->removeObjectScope(interp);
            otclc->destroyClassScope(interp);
            return;

            // Similar to destructors in that we could pass around an att
            // that sadi not to record error - al constructors executued
            // only the first error report!
         }
      }
   }

   removePartScope(interp);
   owner->removeObjectScope(interp);
   otclc->destroyClassScope(interp);

   *result = TCL_OK;
}

int OtclPartOtcl::constructParent (int parentNo, Tcl_Interp *interp, char *args)
{
   OtclClass *otclClass = otclc->giveSuperclass(parentNo);
   if (otclClass == NULL)
   {
      superPart[parentNo] = NULL;
      return TCL_OK;
   }
   else
   {
      int argc;
      char **argv;
      int result = expandParentConstructorArgs(interp,args,&argc,&argv);
      if (result != TCL_OK)
      {
         return result;
      }

      superPart[parentNo] = otclClass->instantiatePart(interp,&result,
                                                       argc,argv,owner,
                                                       &superPart[parentNo]);
      if (result != TCL_OK)
      {
// Do something
      }

      free((char*)argv);
      return result;
   }
}

int OtclPartOtcl::expandParentConstructorArgs (Tcl_Interp *interp, char *args,
                                               int *argc, char **argv[])
{
   int result;
   result = Tcl_VarEval(interp,OTCL_NOP_CMD," ",args,NULL);
   if (result != TCL_OK)
   {
      return result;
   }  

   return Tcl_SplitList(interp,interp->result,argc,argv);
}

OtclPartOtcl::~OtclPartOtcl ()
{
   // clean up attributes.
   Tcl_HashEntry *entry;
   Tcl_HashSearch search;
   for (entry = Tcl_FirstHashEntry(&attributes,&search);
        entry != NULL;
        entry = Tcl_NextHashEntry(&search))
   {
      delete ((OtclAttribute*)Tcl_GetHashValue(entry));
   }
   Tcl_DeleteHashTable(&attributes);
}

int OtclPartOtcl::discardPart (Tcl_Interp *interp, int fromCpp)
{
   // execute destructor
   int result = TCL_OK;

   OtclDestructorMethod *destructor = otclc->giveDestructorMethod();
   if (destructor != NULL)
   {
      otclc->createClassScope(interp);
      owner->addObjectScope(interp);
      addPartScope(interp);
      result = destructor->execute(interp,0,NULL);
      removePartScope(interp);
      owner->removeObjectScope(interp);
      otclc->destroyClassScope(interp);
   }

   // If an error in the body of a destructor, don't execute parent
   // constructors. Any error is serious and we shouldn't bother to attempt
   // to keep memory and status in a sensible state.
   if (result == TCL_OK)
   {
      for (int s = MAX_SUPERCLASSES - 1; s >= 0; s--)
      {
         if (superPart[s] != NULL) 
         {
            if (superPart[s]->discardPart(interp,fromCpp) == TCL_ERROR)
            {
               return TCL_ERROR;
            }
            superPart[s] = NULL;
         }
      }
   }

   delete this;
   return result;
}

void OtclPartOtcl::addPartScope (Tcl_Interp *tclInterp)
{
   Interp *interp = (Interp*)tclInterp;
   Tcl_HashTable *varTable = &interp->framePtr->varTable;
   
   // Add upvar's locating each instance attributes
   Tcl_HashSearch search;
   Tcl_HashEntry *hashEntry;
   Tcl_HashEntry *newEntry;
   OtclAttribute *otcla;
   Var *link;
   int dummy;
   for (hashEntry = Tcl_FirstHashEntry(&attributes,&search);
        hashEntry != NULL;
        hashEntry = Tcl_NextHashEntry(&search))
   {
      otcla = (OtclAttribute*)Tcl_GetHashValue(hashEntry);
      newEntry = Tcl_CreateHashEntry(varTable,
                                     Tcl_GetHashKey(&attributes,hashEntry),
                                     &dummy);
      link = (Var*)malloc(sizeof(Var));
      link->valueLength = 0;
      link->valueSpace = 0;
      link->value.upvarPtr = (Var*)*otcla;
      link->value.upvarPtr->refCount++;
      link->hPtr = newEntry;
      link->refCount = 0;
      link->tracePtr = NULL;
      link->searchPtr = NULL;
      link->flags = VAR_UPVAR;
      Tcl_SetHashValue(newEntry,link);
   }

   char value[10];
   sprintf(value,"%lx",(long)this);
   Tcl_SetVar(tclInterp,OTCL_PART_ATTRIBUTE_NAME,value,0);

}

void OtclPartOtcl::removePartScope (Tcl_Interp *)
{
   // Remove instance attributes from call frame
   // This is done by OtclClass:;destroyCallFrame
}

char *OtclPartOtcl::giveClassName (void)
{
   return otclc->giveName();
}

int OtclPartOtcl::executeMethod (Tcl_Interp *interp, char *methodName, int argc,
                                 char *argv[], int *found)
{
   int result = TCL_OK;

   // Look for it as an instance method at the level of the hierarchy
   OtclInstanceMethod *method = otclc->giveInstanceMethod(methodName);
   if (method != NULL)
   {
      if (method->isAccessible(interp) != OTCL_TRUE)
      {
         Otcl::setTclResult(interp,PRIVATE_METHOD_NO_ACCESS_ERR,methodName,
                            otclc->giveName());
         *found = OTCL_TRUE;
         return TCL_ERROR;
      }
      otclc->createClassScope(interp);
      owner->addObjectScope(interp);
      addPartScope(interp);
      result = method->execute(interp,argc,argv);
      removePartScope(interp);
      owner->removeObjectScope(interp);
      otclc->destroyClassScope(interp);
      *found = OTCL_TRUE;
      return result;
   }

   // Don't look for it in class methods. 

   // Couldn't find it at this level look upwards.
   for (int s = 0; s < MAX_SUPERCLASSES; s++)
   {
      if (superPart[s] != NULL)
      {
         result = superPart[s]->executeMethod(interp,methodName,argc,argv,
                                              found);
         if (*found == OTCL_TRUE)
         {
            return result;
         }
      }
   }

   // Couldn't find it at all!

   *found = OTCL_FALSE;
   return TCL_OK;
}


int OtclPartOtcl::executeParentMethod (Tcl_Interp *interp, char *pClassName,
                                       char *methodName, int argc,
                                       char *argv[], int *found)
{
   int s = otclc->giveIndexOfSuperclass(pClassName);
   if (s == -1)
   {
      // No such superclass!!!!!!!!!!!!
      
      Otcl::setTclResult(interp,NOT_A_BASE_CLASS_ERR,pClassName,
                            otclc->giveName());
      *found = OTCL_TRUE;
      return TCL_ERROR;
   }

   return superPart[s]->executeMethod(interp,methodName,argc,argv,found);
}

void *OtclPartOtcl::toCpp (char *cppClassName)
{
   void *res;
   for (int s = 0; s < MAX_SUPERCLASSES; s++)
   {
      if (superPart[s] != NULL)
      {
         res = superPart[s]->toCpp(cppClassName);
         if (res != NULL)
         {     
            return res;
         }
      }
   }
   return NULL;
}

OtclPartCpp::OtclPartCpp (OtclObject *o) :
   OtclPart(o)
{
}

OtclPartCpp::~OtclPartCpp ()
{
}

void OtclPartCpp::otclErrorMethod (char *mName, char *error)
{
   fprintf(stderr,"Otcl::error in method described in Tcl.\n");
   fprintf(stderr,"      Method name: %s\n",mName);
   fprintf(stderr,"      Error: %s\n",error);
   exit(1);
}
