/*  _ __ ___ _
 * | |\ /  /| |  $Id: Test.C,v 1.7 1995/06/16 13:04:15 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : Test.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Implementation of test classes.
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// System Includes
#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>

// Local Includes
#include "Test.H"

#include "Test_cdl.H"

int SimpleCppClass::objectCount = 0;
Tcl_Interp *testInterp = NULL;

SimpleCppClass::SimpleCppClass (char *s, int v)
{
   objectCount++;
   str = strdup(s);
   val = v;
   Tcl_SetVar (testInterp, "results", "SimpleCppClass constructed",
               TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
}

SimpleCppClass::~SimpleCppClass ()
{
   objectCount--;
   if (str != NULL)
   {
      free(str);
   }
   Tcl_SetVar (testInterp, "results", "SimpleCppClass destructed",
               TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
}

int SimpleCppClass::getValue (void)
{
   return val;
}

void SimpleCppClass::setValue (int v)
{
   val = v;
}

char *SimpleCppClass::getStr (void)
{
   return str;
}

void SimpleCppClass::setStr (char *s)
{
   if (str != NULL)
   {
      free(str);
   }
   str = strdup(s);
}

int SimpleCppClass::getNoOfObjects (void)
{
   return objectCount;
}

SimpleCppClass &SimpleCppClass::getSimpleCppObject (void)
{
   SimpleCppClass *object = new SimpleCppClass("Hello",99);
   return *object;
}

TestCppClass::TestCppClass ()
{
}

TestCppClass::~TestCppClass ()
{
}

void TestCppClass::methodOne ()
{
   methodTwo();
}

void TestCppClass::methodTwo ()
{
   Tcl_SetVar (testInterp, "results", "TestCppClass::methodTwo called",
               TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
}

void TestCppClass::setOtherObject (TestCppClass &oo)
{
   otherObject = &oo;
}

TestCppClass &TestCppClass::getOtherObject (void)
{
   return *otherObject;
}

void TestCppClass::doMethodTwoOnOtherObject (void)
{
   if (otherObject != NULL)
   {
      otherObject->methodTwo();
   }
}


PtrTestClass::PtrTestClass (PtrTestClass *ptr)
{
   if (ptr == NULL)
   {
      Tcl_SetVar (testInterp, "results", "passed ptr == NULL",
                  TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
   }
   else
   {
      Tcl_SetVar (testInterp, "results", "passed ptr != NULL",
                  TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
   }
}

void PtrTestClass::instanceMethodTest (PtrTestClass *ptr)
{
   if (ptr == NULL)
   {
      Tcl_SetVar (testInterp, "results", "passed ptr == NULL",
                  TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
   }
   else
   {
      Tcl_SetVar (testInterp, "results", "passed ptr != NULL",
                  TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
   }
}

void PtrTestClass::classMethodTest (PtrTestClass *ptr)
{
   if (ptr == NULL)
   {
      Tcl_SetVar (testInterp, "results", "passed ptr == NULL",
                  TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
   }
   else
   {
      Tcl_SetVar (testInterp, "results", "passed ptr != NULL",
                  TCL_GLOBAL_ONLY | TCL_LIST_ELEMENT | TCL_APPEND_VALUE);
   }
}

AbstractClass::AbstractClass ()
{
}
