/*
 * dirent.h --
 */

#ifndef _DIRENT
#define _DIRENT

#ifndef _TCL
#include "tcl.h"
#endif

#include "tclunix.h"


/*
 * Dirent structure, which holds information about a single
 * directory entry.
 */

#define MAXNAMLEN 13

typedef struct dirent	DIRENT;
struct dirent {
#ifdef NOT_USED
	long	d_ino;			/* Inode number of entry */
#endif
	short	d_reclen;		/* Length of this record */
	short	d_namlen;		/* Length of string in d_name */
	char	d_name[MAXNAMLEN + 1];	/* Name must be no longer than this */
};

/*
 * State that keeps track of the reading of a directory (clients
 * should never look inside this structure;  the fields should
 * only be accessed by the library procedures).
 */

#define D_MAGIC	99
typedef struct _dirdesc {
	long	dd_loc;
	long	dd_size;
	DIRENT	*dd_buf;
	int	dd_magic;
} DIR;

/*
 * Procedures defined for reading directories:
 */

extern int		closedir _ANSI_ARGS_((DIR *dirp));
extern DIR *		opendir _ANSI_ARGS_((char *name));
extern struct dirent *	readdir _ANSI_ARGS_((DIR *dirp));

#endif /* _DIRENT */
