


regsub(n)             Tcl Built-In Commands             regsub(n)



_________________________________________________________________

NAME
     regsub - Perform substitutions based on  regular  expression
     pattern matching

SYNOPSIS
     regsub ?switches? exp string subSpec varName
_________________________________________________________________


DESCRIPTION
     This command matches  the  regular  expression  exp  against
     string,  and  it copies string to the variable whose name is  |
     given by varName.  The command returns 1 if there is a match  |
     and 0 if there isn't.  If there is a match, then while copy-  |
     ing string to varName the portion of string that matched exp
     is  replaced  with  subSpec.  If subSpec contains a ``&'' or
     ``\0'', then it is replaced in  the  substitution  with  the
     portion  of  string that matched exp.  If subSpec contains a
     ``\n'', where n is a digit between  1  and  9,  then  it  is
     replaced in the substitution with the portion of string that
     matched the n-th parenthesized subexpression of exp.   Addi-
     tional backslashes may be used in subSpec to prevent special
     interpretation of ``&'' or ``\0'' or  ``\n''  or  backslash.
     The  use  of  backslashes in subSpec tends to interact badly
     with the Tcl parser's use of backslashes, so it's  generally
     safest   to   enclose  subSpec  in  braces  if  it  includes
     backslashes.

     If the initial arguments to regexp start with  -  then  they  |
     are   treated  as  switches.   The  following  switches  are  |
     currently supported:                                          |

     -all                                                               ||
               All  ranges in string that match exp are found and  |
               substitution  is  performed  for  each  of   these  |
               ranges.  Without this switch only the first match-  |
               ing range is found and substituted.   If  -all  is  |
               specified,  then  ``&''  and  ``\n'' sequences are  |
               handled for each substitution using  the  informa-  |
               tion from the corresponding match.                  |

     -nocase                                                            ||
               Upper-case  characters in string will be converted  |
               to lower-case before matching against  exp;   how-  |
               ever,  substitutions  specified by subSpec use the  |
               original unconverted form of string.                |

     --                                                                 ||
               Marks the end of switches.  The argument following  |
               this one will be treated as exp even if it  starts  |



Tcl                      Last change:                           1






regsub(n)             Tcl Built-In Commands             regsub(n)



               with a -.

     See the manual entry for regexp for details on the interpre-
     tation of regular expressions.


KEYWORDS
     match, pattern, regular expression, substitute















































Tcl                      Last change:                           2



