/*
 * winio.h
 * 
 * Stdio (e.g. printf) functionality for Windows - definition.
 * Originally in Microsoft Systems Journal, July 1991, by Dave Maxey
 */

#ifndef _WINIO_H
#define _WINIO_H

#ifdef __cplusplus
extern "C" {
#endif

/* ==== STDIO.H for Windows ==== */
#include <stdarg.h>
#ifdef __BORLANDC__
/* Borland C++ STDIO.H doesn't do gets, etc. #if defined(_Windows) */
#undef _Windows
#include <stdio.h>
#define _Windows
#else
#include <stdio.h>
#endif

#undef putchar
#define putchar	fputchar
#undef getchar
#define getchar	fgetchar

/*
 * These were missing from original MSJ version, which assumes inclusion
 * of WINDOWS.H as well as WINIO.H.  #ifndef PASCAL is a semi-unreliable
 * way to check for inclusion of any vendor's WINDOWS.H
 */
#ifndef PASCAL
typedef unsigned	HANDLE;
typedef unsigned char	BYTE;
typedef unsigned	WORD;
typedef unsigned	BOOL;
typedef unsigned long	DWORD;
typedef unsigned	HWND;
typedef long		LONG;
#define PASCAL		pascal
#define FAR		far
#endif

/* ==== Extensions ==== */

/*
 * winio_init() must be called before any of the above listed
 * functions to init the i/o window. Similar arguments to WinMain(), but
 * we drop the cmdline pointer but add a bufsize parameter (unsigned) -
 * 0 means default (8k).
 */
extern int	winio_init(HANDLE, HANDLE, int, unsigned);

/*
 * Makes the window inactive, and allows the user to view and play with
 * it until double- clicking on the system menu to close it. NEVER RETURNS.
 */
extern void 	winio_end(void);

/* closes the window immediately and frees up buffers */
extern void	winio_close(void);

/* To set the window title to override default title */
extern void	winio_settitle(BYTE *);

/* May be SYSTEM_FIXED_FONT (default), ANSI_FIXED_FONT, or OEM_FIXED_FONT */
extern BOOL	winio_setfont(WORD);

/* To turn automatic updating of window off and on */
extern BOOL	winio_setpaint(BOOL);

/* To change the behavior of getchar() */
extern BOOL	winio_setecho(BOOL);

/* clear out the contents of the buffer and start over fresh */
extern void	winio_clear(void);

/*
 * should be used to release cpu in spells between I/O calls.  A
 * WM_QUIT message received by it will exit the application.  If that is
 * a problem, use the winio_onclose function below
 */
extern void	winio_yield(void);

/* Returns the underlying Windows window handle to WINIO window */
extern HWND	winio_hwnd(void);

/* ==== User definable exit routine ==== */
typedef void (* DESTROY_FUNC)(void);

/*
 * Optional notification function; without it, there is no way for your
 * application to know if the user has double-clicked the system menu box
 */
extern void	winio_onclose(DESTROY_FUNC);

/* ==== Utility function built on message box ==== */
extern BOOL	winio_warn(BOOL, const BYTE *, ...);

#ifdef __cplusplus
}
#endif

#endif /* _WINIO_H */
