otclInterface Game {
   constructor {mark player}

   method setOpponent {opponent}
   method opponentRegistered {opponent}

   method iveMoved {row col}
   method opponentMoved {row col}

   method getName {}

   method quit {}
   method opponentQuit {}
}

otclImplementation Game {
   constructor {m p} {} {
      set myMark $m
      set player $p
      if {$m == "X"} {
         set opponentMark "O"
      } else {
         set opponentMark "X"
      }
 
      set toplevel [toplevel ".a$nextToplevel"]
      incr nextToplevel

      foreach row {0 1 2} {
         pack append $toplevel [frame $toplevel.$row] {left fillx filly}
         foreach col {0 1 2} {
            button $toplevel.$row.$col -width 2
            pack append $toplevel.$row $toplevel.$row.$col {top fillx}
         }
      }

      wm protocol $toplevel WM_DELETE_WINDOW "$this quit"

   }

   destructor {
      destroy $toplevel
   }

   method setOpponent {o} {
      set opponent $o
      $o opponentRegistered $this
      wm title $toplevel "[$opponent getName]"
      $this myGo
   }

   method opponentRegistered {o} {
      set opponent $o
      wm title $toplevel "[$opponent getName]"
      $this theirGo
   }

   method iveMoved {row col} {
      $toplevel.$row.$col configure -text $myMark
      $toplevel.$row.$col configure -state disabled
      $opponent opponentMoved $row $col
      if {![$this hasPlayerOne $myMark]} {
         $this theirGo
      } else {
         $this gameFinished
      }
   }

   method opponentMoved {row col} {
      $toplevel.$row.$col configure -text $opponentMark
      $toplevel.$row.$col configure -state disabled
      if {![$this hasPlayerOne $opponentMark]} {
         $this myGo
      } else {
         $this gameFinished
      }
   }

   method theirGo {} {
      # set all inactive
      foreach r {0 1 2} {
         foreach c {0 1 2} {
            $toplevel.$r.$c configure -command ""
         }
      }
      $toplevel configure -cursor watch
   }

   method myGo {} {
      foreach r {0 1 2} {
         foreach c {0 1 2} {
            $toplevel.$r.$c configure -command "$this iveMoved $r $c"
         }
      }
      $toplevel configure -cursor hand1
   }

   method gameFinished {} {
      # set all inactive
      foreach r {0 1 2} {
         foreach c {0 1 2} {
            $toplevel.$r.$c configure -state disabled
         }
      }
      $toplevel configure -cursor star
   }

   # Checks to see if the player with mark "mark" has one
   method hasPlayerOne {mark} {

      # Check columns
      foreach c {0 1 2} {
         if {([lindex [$toplevel.0.$c configure -text] 4] == $mark) && \
             ([lindex [$toplevel.1.$c configure -text] 4] == $mark) && \
             ([lindex [$toplevel.2.$c configure -text] 4] == $mark)} {
            return 1
         }
      }

      # Check the rows
      foreach r {0 1 2} {
         if {([lindex [$toplevel.$r.0 configure -text] 4] == $mark) && \
             ([lindex [$toplevel.$r.1 configure -text] 4] == $mark) && \
             ([lindex [$toplevel.$r.2 configure -text] 4] == $mark)} {
            return 1
         }
      }

      # Check to two diagnals
      if {([lindex [$toplevel.0.0 configure -text] 4] == $mark) && \
          ([lindex [$toplevel.1.1 configure -text] 4] == $mark) && \
          ([lindex [$toplevel.2.2 configure -text] 4] == $mark)} {
         return 1
      }

      if {([lindex [$toplevel.0.2 configure -text] 4] == $mark) && \
          ([lindex [$toplevel.1.1 configure -text] 4] == $mark) && \
          ([lindex [$toplevel.2.0 configure -text] 4] == $mark)} {
         return 1
      }

      return 0
   }

   method getName {} {
      return [$player getName]
   }

   method quit {} {
      $opponent opponentQuit
      otclDelete $this
   }

   method opponentQuit {} {
      otclDelete $this
   }

   attribute toplevel
   attribute myMark
   attribute opponentMark
   attribute opponent
   attribute player

   classAttribute nextToplevel 0
}

