# showVars2 w var var var ...
#
# Create a top-level window that displays a bunch of global variable values
# and keeps the display up-to-date even when the variables change value
#
# Arguments:
#    w -	Name to use for new top-level window.
#    var -	Name of variable to monitor.
#
# modified by k.furukawa, apr.1993. for 16bit kanji font

proc showVars2 {w args} {
    catch {destroy $w}
    toplevel $w
    wm title $w "Variable values"
    label $w.title -text "ѿ͡" -width 20 -anchor center \
	    -font k14
    pack append $w $w.title {top fillx}
    foreach i $args {
	frame $w.v$i
	label $w.v$i.name -text "${i}" -font k14
	label $w.v$i.value -textvar $i
	pack append $w.v$i $w.v$i.name left $w.v$i.value left
	pack append $w $w.v$i {top frame w}
    }
    button $w.ok -text ϣ -font k14 -command "destroy $w"
    pack append $w $w.ok {bottom pady 2}
}
