/* 
 * interpAppInit.c --
 *
 *	Initializes the interp extension
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

static char sccsid[] = "%Z% %M% %I% %E% %U%";

#include	<stdio.h>
#include	<stdlib.h>
#include	<tcl.h>

#ifdef		WITH_TK
#include	<tk.h>
#endif

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

#ifdef NEED_MATHERR
extern int matherr();
int *tclDummyMathPtr = (int *) matherr;
#endif

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	Initializes a Tcl application.
 *
 * Results:
 *	Indicates success or failure by return status.
 *
 * Side effects:
 *	Causes the interpreter to be initialized.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;			/* The interpreter to initialize. */
{
    /*
     * Initialize the interpreter with the standard Tcl facilities:
     */
    if (Tcl_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#ifdef	WITH_TK
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    
#endif
    if (Interp_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

#ifdef	TEST
    if (Test_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#endif

    return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tcl_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
{
#ifdef	WITH_TK
    Tk_Main(argc, argv, Tcl_AppInit);
#endif

#ifndef WITH_TK
    Tcl_Main(argc, argv, Tcl_AppInit);
#endif

    return 0;			/* Needed only to prevent compiler warning. */
}
