source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## b::b 1
## b::f 1 x y z
## b::g 1 x y z
## a::h 1 x y z
## invalid command name "b::i"

## A::A 2
## B::B 2
## B::f 2 x y z
## B::g 2 x y z
## A::h 2 x y z
## invalid command name "B::i"

class a {}
proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
virtual proc a::f {this p q} {}
virtual proc a::g {this p q}
virtual proc a::h {this p q} {
    puts "a::h $this $p $q"
}
virtual proc a::i {this p q}
class b {}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
virtual proc b::f {this p q} {
    puts "b::f $this $p $q"
}
virtual proc b::g {this p q} {
    puts "b::g $this $p $q"
}
set o [new b]
a::f $o x {y z}
a::g $o x {y z}
a::h $o x {y z}
catch {a::i $o x {y z}} message
puts $message

class A {
    proc A {this} {
        puts "A::A $this"
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
    virtual proc f {this p q} {}
    virtual proc g {this p q}
    virtual proc h {this p q} {
        puts "A::h $this $p $q"
    }
    virtual proc i {this p q}
}
class B {
    proc B {this} A {} {
        puts "B::B $this"
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
    virtual proc f {this p q} {
        puts "B::f $this $p $q"
    }
    virtual proc g {this p q} {
        puts "B::g $this $p $q"
    }
}
set o [new B]
A::f $o x {y z}
A::g $o x {y z}
A::h $o x {y z}
catch {A::i $o x {y z}} message
puts $message
