source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## b::b 1
## b::f 1 x y {1 2} 3
## a::g 1 x y {1 2} 3

## A::A 2
## B::B 2
## B::f 2 x y {1 2} 3
## A::g 2 x y {1 2} 3
 
class a {}
proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
virtual proc a::f {this p args} {}
proc a::g {this p args} {
    puts "a::g $this $p $args"
}
class b {}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
virtual proc b::f {this p args} {
    puts "b::f $this $p $args"
}
set o [new b]
a::f $o {x y} {1 2} 3
a::g $o {x y} {1 2} 3

class A {
    proc A {this} {
        puts "A::A $this"
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
    virtual proc f {this p args} {}
    proc g {this p args} {
        puts "A::g $this $p $args"
    }
}
class B {
    proc B {this} A {} {
        puts "B::B $this"
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
    virtual proc f {this p args} {
        puts "B::f $this $p $args"
    }
}
set o [new B]
A::f $o {x y} {1 2} 3
A::g $o {x y} {1 2} 3
