source parray.tcl
source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1 x y X Y {1 2} 3
## b::b 1 x y X Y {1 2} 3
## a::(1,_derived) = b
## a::(1,m) = 1 2
## a::(1,p) = x y
## a::(1,q) = X Y
## b::(1,n) = 1 2

## A::A 2 x y X Y {1 2} 3
## B::B 2 x y X Y {1 2} 3
## A::(2,_derived) = B
## A::(2,m) = 1 2
## A::(2,p) = x y
## A::(2,q) = X Y
## B::(2,n) = 1 2

class a {}
proc a::a {this p q args} {
    puts "a::a $this $p $q $args"
    set a::($this,m) [lindex $args 0]
    set a::($this,p) $p
    set a::($this,q) $q
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this p q args} a {$p $q $args} {
    puts "b::b $this $p $q $args"
    set b::($this,n) [lindex $args 0]
}
proc b::~b {this} {
    puts "b::~b $this"
}
new b {x y} {X Y} {1 2} 3
printArrays a:: b::

class A {
    proc A {this p q args} {
        puts "A::A $this $p $q $args"
        set A::($this,m) [lindex $args 0]
        set A::($this,p) $p
        set A::($this,q) $q
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this p q args} A {$p $q $args} {
        puts "B::B $this $p $q $args"
        set B::($this,n) [lindex $args 0]
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
new B {x y} {X Y} {1 2} 3
printArrays A:: B::
