source parray.tcl
source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1 {1 2} 3
## b::b 1 {1 2} 3
## a::(1,_derived) = b
## a::(1,m) = 1 2
## b::(1,n) = 1 2

## A::A 2 {1 2} 3
## B::B 2 {1 2} 3
## A::(2,_derived) = B
## A::(2,m) = 1 2
## B::(2,n) = 1 2

class a {}
proc a::a {this args} {
    puts "a::a $this $args"
    set a::($this,m) [lindex $args 0]
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this args} a {$args} {
    puts "b::b $this $args"
    set b::($this,n) [lindex $args 0]
}
proc b::~b {this} {
    puts "b::~b $this"
}
new b {1 2} 3
printArrays a:: b::

class A {
    proc A {this args} {
        puts "A::A $this $args"
        set A::($this,m) [lindex $args 0]
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this args} A {$args} {
        puts "B::B $this $args"
        set B::($this,n) [lindex $args 0]
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
new B {1 2} 3
printArrays A:: B::
