source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## b::b 1
## b::f 1 x y z
## a::h 1 x y z
## b::g 1 x y {1 2} 3 {4 5}
## a::g 1 x y {1 2} 3 {4 5}

## A::A 2
## B::B 2
## B::f 2 x y z
## A::h 2 x y z
## B::g 2 x y {1 2} 3 {4 5}
## A::g 2 x y {1 2} 3 {4 5}

class a {}
proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
virtual proc a::f {this p q} {
    puts "a::h $this $p $q"
}
virtual proc a::g {this p args} {
    puts "a::g $this $p $args"
}
class b {}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
proc b::f {this p q} {
    puts "b::f $this $p $q"
    a::_f $this $p $q
}
proc b::g {this p args} {
    puts "b::g $this $p $args"
    eval a::_g $this $p $args
}
set o [new b]
a::f $o x {y z}
a::g $o {x y} {1 2} 3 {4 5}

class A {
    proc A {this} {
        puts "A::A $this"
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
    virtual proc f {this p q} {
        puts "A::h $this $p $q"
    }
    virtual proc g {this p args} {
        puts "A::g $this $p $args"
    }
}
class B {
    proc B {this} A {} {
        puts "B::B $this"
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
    proc f {this p q} {
        puts "B::f $this $p $q"
        A::_f $this $p $q
    }
    proc g {this p args} {
        puts "B::g $this $p $args"
        eval A::_g $this $p $args
    }
}
set o [new B]
A::f $o x {y z}
A::g $o {x y} {1 2} 3 {4 5}
