source parray.tcl
source stooop.tcl
namespace import stooop::*

### check multiple inheritance construction order, destruction order and data deallocation

# expected output:

## a::a 1
## b::b 1
## c::c 1
## a::(1,_derived) = c
## a::(1,m) = x y
## b::(1,_derived) = c
## b::(1,n) = z
## c::(1,o) = 1 2
## c::~c 1
## b::~b 1
## a::~a 1

## A::A 2
## B::B 2
## C::C 2
## A::(2,_derived) = C
## A::(2,m) = x y
## B::(2,_derived) = C
## B::(2,n) = z
## C::(2,o) = 1 2
## C::~C 2
## B::~B 2
## A::~A 2

class a {}
proc a::a {this p} {
    puts "a::a $this"
    set a::($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this p} {
    puts "b::b $this"
    set b::($this,n) $p
}
proc b::~b {this} {
    puts "b::~b $this"
}
class c {}
proc c::c {this p q r} a {$p} b {$q} {
    puts "c::c $this"
    set c::($this,o) $r
}
proc c::~c {this} {
    puts "c::~c $this"
}
set o [new c {x y} z {1 2}]
printArrays a:: b:: c::
delete $o
printArrays a:: b:: c::

class A {
    proc A {this p} {
        puts "A::A $this"
        set A::($this,m) $p
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this p} {
        puts "B::B $this"
        set B::($this,n) $p
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
class C {
    proc C {this p q r} A {$p} B {$q} {
        puts "C::C $this"
        set C::($this,o) $r
    }
    proc ~C {this} {
        puts "C::~C $this"
    }
}
set o [new C {x y} z {1 2}]
printArrays A:: B:: C::
delete $o
printArrays A:: B:: C::
