source stooop.tcl
namespace import stooop::*

### check various virtual procedures with variable number of arguments configurations in a 3 level deep class hierarchy

# expected output:

## c::f 1 x {y z}
## c::g 1 x {y z}
## b::h 1 x {y z}
## b::i 1 x {y z}
## c::k 1 x {y z}
## c::l 1 x {y z}

## C::f 2 x {y z}
## C::g 2 x {y z}
## B::h 2 x {y z}
## B::i 2 x {y z}
## C::k 2 x {y z}
## C::l 2 x {y z}

class a {}
proc a::a {this} {}
proc a::~a {this} {}
virtual proc a::f {this p args} {}
virtual proc a::g {this p args}
virtual proc a::h {this p args} {
    puts "a::h $this $p $args"
}
virtual proc a::i {this p args} {
    puts "a::i $this $p $args"
}
virtual proc a::k {this p args}
virtual proc a::l {this p args} {
    puts "a::l $this $p $args"
}
class b {}
proc b::b {this} a {} {}
proc b::~b {this} {}
virtual proc b::f {this p args} {
    puts "b::f $this $p $args"
}
virtual proc b::g {this p args}
virtual proc b::h {this p args} {
    puts "b::h $this $p $args"
}
proc b::i {this p args} {
    puts "b::i $this $p $args"
}
virtual proc b::k {this p args} {
    puts "b::k $this $p $args"
}
virtual proc b::l {this p args}
class c {}
proc c::c {this} b {} {}
proc c::~c {this} {}
proc c::f {this p args} {
    puts "c::f $this $p $args"
}
proc c::g {this p args} {
    puts "c::g $this $p $args"
}
proc c::i {this p args} {
    puts "c::i $this $p $args"
}
proc c::k {this p args} {
    puts "c::k $this $p $args"
}
proc c::l {this p args} {
    puts "c::l $this $p $args"
}
set o [new c]
a::f $o x {y z}
a::g $o x {y z}
a::h $o x {y z}
a::i $o x {y z}
a::k $o x {y z}
a::l $o x {y z}

class A {
    proc A {this} {}
    proc ~A {this} {}
    virtual proc f {this p args} {}
    virtual proc g {this p args}
    virtual proc h {this p args} {
        puts "A::h $this $p $args"
    }
    virtual proc i {this p args} {
        puts "A::i $this $p $args"
    }
    virtual proc k {this p args}
    virtual proc l {this p args} {
        puts "A::l $this $p $args"
    }
}
class B {
    proc B {this} A {} {}
    proc ~B {this} {}
    virtual proc f {this p args} {
        puts "B::f $this $p $args"
    }
    virtual proc g {this p args}
    virtual proc h {this p args} {
        puts "B::h $this $p $args"
    }
    proc i {this p args} {
        puts "B::i $this $p $args"
    }
    virtual proc k {this p args} {
        puts "B::k $this $p $args"
    }
    virtual proc l {this p args}
}
class C {
    proc C {this} B {} {}
    proc ~C {this} {}
    proc f {this p args} {
        puts "C::f $this $p $args"
    }
    proc g {this p args} {
        puts "C::g $this $p $args"
    }
    proc i {this p args} {
        puts "C::i $this $p $args"
    }
    proc k {this p args} {
        puts "C::k $this $p $args"
    }
    proc l {this p args} {
        puts "C::l $this $p $args"
    }
}
set o [new C]
A::f $o x {y z}
A::g $o x {y z}
A::h $o x {y z}
A::i $o x {y z}
A::k $o x {y z}
A::l $o x {y z}
