source parray.tcl
source stooop.tcl
namespace import stooop::*

### check cloning operation in a 3 level deep class hierarchy

# expected output:

## a::(1,_derived) = b
## a::(1,x) = 0
## a::(2,_derived) = b
## a::(2,x) = 0
## b::(1,_derived) = c
## b::(1,y) = 1
## b::(2,_derived) = c
## b::(2,y) = 1
## c::(1,z) = 2
## c::(2,z) = 2

## A::(3,_derived) = B
## A::(3,x) = 0
## A::(4,_derived) = B
## A::(4,x) = 0
## B::(3,_derived) = C
## B::(3,y) = 1
## B::(4,_derived) = C
## B::(4,y) = 1
## C::(3,z) = 2
## C::(4,z) = 2

class a {}
proc a::a {this} {
    set a::($this,x) 0
}
class b {}
proc b::b {this} a {} {
    set b::($this,y) 1
}
class c {}
proc c::c {this} b {} {
    set c::($this,z) 2
}
new [new c]
printArrays a:: b:: c::

class A {
    proc A {this} {
        set A::($this,x) 0
    }
}
class B {
    proc B {this} A {} {
        set B::($this,y) 1
    }
}
class C {
    proc C {this} B {} {
        set C::($this,z) 2
    }
}
new [new C]
printArrays A:: B:: C::
